"""
A collection of classes for administering ArcGIS Server sites.
"""
from .catalog import ServicesDirectory
from ._service import Service
from .admin.parameters import Extension
from .sm import ServerManager
from .catalog import ServicesDirectory
from .admin import Server
from .admin.administration import SiteManager
from .admin._clusters import Cluster, ClusterProtocol, Clusters
from .admin._data import Datastore, DataStoreManager
from .admin._info import Info
from .admin._kml import KML
from .admin._logs import LogManager
from .admin._machines import Machine, MachineManager
from .admin._mode import Mode
from .admin._security import Role, RoleManager, User, UserManager
from .admin._services import (
    Service,
    ServiceManager,
    ItemInformationManager,
    JobManager,
    Job,
)
from .admin._system import ConfigurationStore, DirectoryManager, Jobs
from .admin._system import ServerDirectory, ServerProperties, SystemManager
from .admin._uploads import Uploads
from .admin._usagereports import Report, ReportManager
from .admin._mode import Mode
