pyteomics.pepxmltk - a pepXML writer and Tandem2XML converter
---------------------------------------------------------------

**pyteomics.pepxmltk** is a module based on the
[pyteomics](https://pyteomics.readthedocs.io/) package that
allows creation of
[pepXML](http://tools.proteomecenter.org/wiki/index.php?title=Formats:pepXML)
files from Python objects of a certain structure. The structure corresponds to
tokens generated by the pyteomics TandemXML parser.

This package provides a module that can be used for writing pepXML files
from your Python code, as well as a command-line script for conversion, merging
or filtering of X!Tandem files to pepXML. Unlike its analog from Trans-Proteomic
Pipeline (TPP), the script is capable of handling non-standard enzymes.

The package contains two scripts: **pepxmltk.py** and **runtandem**.
**pepxmltk.py** does conversion from X!Tandem XML to pepXML, or from pepXML to pepXML, while optionally
combining multiple files and performing FDR filtering.
**runtandem** is a CLI wrapper that simplifies the repetitive actions of creating *taxonomy.xml*,
running X!Tandem, and converting the result to pepXML.

Dependencies
------------

- pyteomics
- numpy
- lxml
- jinja2

Links
-----

- PyPI: https://pypi.org/project/pyteomics.pepxmltk/
- BitBucket repo & issue tracker: https://bitbucket.org/markmipt/pyteomics.pepxmltk
- Mailing list: pyteomics@googlegroups.com
