# Xray Tomography

<!-- Please write anything you'd like to explain about the forward problem here -->

In this example, we consider performing X-Ray Tomography (XRT) to image the interior 
of a structure. We assume that the x-rays travel at the same speed regardless of the 
medium through which they are passing, and so their paths are straight lines between 
source and receiver. However, the medium causes the x-rays to attenuate: paths through 
dense objects (such as bones!) arrive at the receiver with far less energy than they 
had at the source. Thus, by analysing the attenuation along many different paths, we 
can build up a picture of the interior of an object.

Specifically, we will assume that the intensity at the receiver, $I_{rec}$, is 
related to the intensity at the source, $I_{src}$ by 
$I_{rec} = I_{src}\exp\left\{-\int_\mathrm{path} \mu(\mathbf{x})\,\mathrm{d}\mathbf{l}\right\}$

where $\mu(\mathbf{x})$ is a position-dependent attenuation coefficient. To obtain 
a linear inverse problem, we rewrite this as 
$-\log \frac{I_{rec}}{I_{src}}=\int_\mathrm{path} \mu(\mathbf{x})\,\mathrm{d}\mathbf{l}\,.$ 

We know that 
$\int\left[f(x) + g(x)\right]\,\mathrm{d}x = \int f(x)\,\mathrm{d}x + \int g(x)\,\mathrm{d}x$ 

so we say that integration is a *linear* operation, and hence we can solve the XRT 
problem with linear inverse theory.

We will assume that the object we are interested in is 2-dimensional, so that 
$\mu(\boldsymbol{x}) = \mu(x,y)$. If we discretize this model, with $N_x$ cells in the 
$x$-direction and $N_y$ cells in the $y$-direction, we can express $\mu(x,y)$ as an 
$N_x \times N_y$ vector $\boldsymbol{\mu}$. This is related to the data by
$d_i = A_{ij}\mu_j$

where $d_i = -\log {I^{(i)}_{rec}}/{I^{(i)}_{src}}$, and where $A_{ij}$ represents the 
path length in cell $j$ of the discretized model.
