# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class VerificationCheckList(ListResource):

    def __init__(self, version, service_sid):
        """
        Initialize the VerificationCheckList

        :param Version version: Version that contains the resource
        :param service_sid: The SID of the Service that the resource is associated with

        :returns: twilio.rest.verify.v2.service.verification_check.VerificationCheckList
        :rtype: twilio.rest.verify.v2.service.verification_check.VerificationCheckList
        """
        super(VerificationCheckList, self).__init__(version)

        # Path Solution
        self._solution = {'service_sid': service_sid, }
        self._uri = '/Services/{service_sid}/VerificationCheck'.format(**self._solution)

    def create(self, code=values.unset, to=values.unset,
               verification_sid=values.unset, amount=values.unset,
               payee=values.unset):
        """
        Create the VerificationCheckInstance

        :param unicode code: The verification string
        :param unicode to: The phone number or email to verify
        :param unicode verification_sid: A SID that uniquely identifies the Verification Check
        :param unicode amount: The amount of the associated PSD2 compliant transaction.
        :param unicode payee: The payee of the associated PSD2 compliant transaction

        :returns: The created VerificationCheckInstance
        :rtype: twilio.rest.verify.v2.service.verification_check.VerificationCheckInstance
        """
        data = values.of({
            'Code': code,
            'To': to,
            'VerificationSid': verification_sid,
            'Amount': amount,
            'Payee': payee,
        })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return VerificationCheckInstance(self._version, payload, service_sid=self._solution['service_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Verify.V2.VerificationCheckList>'


class VerificationCheckPage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the VerificationCheckPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param service_sid: The SID of the Service that the resource is associated with

        :returns: twilio.rest.verify.v2.service.verification_check.VerificationCheckPage
        :rtype: twilio.rest.verify.v2.service.verification_check.VerificationCheckPage
        """
        super(VerificationCheckPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of VerificationCheckInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.verify.v2.service.verification_check.VerificationCheckInstance
        :rtype: twilio.rest.verify.v2.service.verification_check.VerificationCheckInstance
        """
        return VerificationCheckInstance(self._version, payload, service_sid=self._solution['service_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Verify.V2.VerificationCheckPage>'


class VerificationCheckInstance(InstanceResource):

    class Channel(object):
        SMS = "sms"
        CALL = "call"
        EMAIL = "email"
        WHATSAPP = "whatsapp"
        SNA = "sna"

    def __init__(self, version, payload, service_sid):
        """
        Initialize the VerificationCheckInstance

        :returns: twilio.rest.verify.v2.service.verification_check.VerificationCheckInstance
        :rtype: twilio.rest.verify.v2.service.verification_check.VerificationCheckInstance
        """
        super(VerificationCheckInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'sid': payload.get('sid'),
            'service_sid': payload.get('service_sid'),
            'account_sid': payload.get('account_sid'),
            'to': payload.get('to'),
            'channel': payload.get('channel'),
            'status': payload.get('status'),
            'valid': payload.get('valid'),
            'amount': payload.get('amount'),
            'payee': payload.get('payee'),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
            'sna_attempts_error_codes': payload.get('sna_attempts_error_codes'),
        }

        # Context
        self._context = None
        self._solution = {'service_sid': service_sid, }

    @property
    def sid(self):
        """
        :returns: The unique string that identifies the resource
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def service_sid(self):
        """
        :returns: The SID of the Service that the resource is associated with
        :rtype: unicode
        """
        return self._properties['service_sid']

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the resource
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def to(self):
        """
        :returns: The phone number or email being verified
        :rtype: unicode
        """
        return self._properties['to']

    @property
    def channel(self):
        """
        :returns: The verification method to use
        :rtype: VerificationCheckInstance.Channel
        """
        return self._properties['channel']

    @property
    def status(self):
        """
        :returns: The status of the verification resource
        :rtype: unicode
        """
        return self._properties['status']

    @property
    def valid(self):
        """
        :returns: Whether the verification was successful
        :rtype: bool
        """
        return self._properties['valid']

    @property
    def amount(self):
        """
        :returns: The amount of the associated PSD2 compliant transaction.
        :rtype: unicode
        """
        return self._properties['amount']

    @property
    def payee(self):
        """
        :returns: The payee of the associated PSD2 compliant transaction
        :rtype: unicode
        """
        return self._properties['payee']

    @property
    def date_created(self):
        """
        :returns: The ISO 8601 date and time in GMT when the Verification Check resource was created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The ISO 8601 date and time in GMT when the Verification Check resource was last updated
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def sna_attempts_error_codes(self):
        """
        :returns: List of error codes as a result of attempting a verification using the `sna` channel.
        :rtype: list[dict]
        """
        return self._properties['sna_attempts_error_codes']

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Verify.V2.VerificationCheckInstance>'
