# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import serialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class VerificationList(ListResource):

    def __init__(self, version, service_sid):
        """
        Initialize the VerificationList

        :param Version version: Version that contains the resource
        :param service_sid: The SID of the Service that the resource is associated with

        :returns: twilio.rest.verify.v2.service.verification.VerificationList
        :rtype: twilio.rest.verify.v2.service.verification.VerificationList
        """
        super(VerificationList, self).__init__(version)

        # Path Solution
        self._solution = {'service_sid': service_sid, }
        self._uri = '/Services/{service_sid}/Verifications'.format(**self._solution)

    def create(self, to, channel, custom_friendly_name=values.unset,
               custom_message=values.unset, send_digits=values.unset,
               locale=values.unset, custom_code=values.unset, amount=values.unset,
               payee=values.unset, rate_limits=values.unset,
               channel_configuration=values.unset, app_hash=values.unset,
               template_sid=values.unset,
               template_custom_substitutions=values.unset, device_ip=values.unset):
        """
        Create the VerificationInstance

        :param unicode to: The phone number or email to verify
        :param unicode channel: The verification method to use
        :param unicode custom_friendly_name: A custom user defined friendly name
        :param unicode custom_message: The text of a custom message to use for the verification
        :param unicode send_digits: The digits to send after a phone call is answered
        :param unicode locale: The override locale to use for the verification SMS, WhatsApp or call
        :param unicode custom_code: A pre-generated code
        :param unicode amount: The amount of the associated PSD2 compliant transaction.
        :param unicode payee: The payee of the associated PSD2 compliant transaction
        :param dict rate_limits: The custom key-value pairs of Programmable Rate Limits.
        :param dict channel_configuration: Channel specific configuration in json format.
        :param unicode app_hash: Your App Hash to be appended at the end of an SMS.
        :param unicode template_sid: The verification template SMS or Voice message.
        :param unicode template_custom_substitutions: The values of the special variables declared on the message template.
        :param unicode device_ip: Encouraged if using the auto channel. The IP address of the client's device.

        :returns: The created VerificationInstance
        :rtype: twilio.rest.verify.v2.service.verification.VerificationInstance
        """
        data = values.of({
            'To': to,
            'Channel': channel,
            'CustomFriendlyName': custom_friendly_name,
            'CustomMessage': custom_message,
            'SendDigits': send_digits,
            'Locale': locale,
            'CustomCode': custom_code,
            'Amount': amount,
            'Payee': payee,
            'RateLimits': serialize.object(rate_limits),
            'ChannelConfiguration': serialize.object(channel_configuration),
            'AppHash': app_hash,
            'TemplateSid': template_sid,
            'TemplateCustomSubstitutions': template_custom_substitutions,
            'DeviceIp': device_ip,
        })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return VerificationInstance(self._version, payload, service_sid=self._solution['service_sid'], )

    def get(self, sid):
        """
        Constructs a VerificationContext

        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.verify.v2.service.verification.VerificationContext
        :rtype: twilio.rest.verify.v2.service.verification.VerificationContext
        """
        return VerificationContext(self._version, service_sid=self._solution['service_sid'], sid=sid, )

    def __call__(self, sid):
        """
        Constructs a VerificationContext

        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.verify.v2.service.verification.VerificationContext
        :rtype: twilio.rest.verify.v2.service.verification.VerificationContext
        """
        return VerificationContext(self._version, service_sid=self._solution['service_sid'], sid=sid, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Verify.V2.VerificationList>'


class VerificationPage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the VerificationPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param service_sid: The SID of the Service that the resource is associated with

        :returns: twilio.rest.verify.v2.service.verification.VerificationPage
        :rtype: twilio.rest.verify.v2.service.verification.VerificationPage
        """
        super(VerificationPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of VerificationInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.verify.v2.service.verification.VerificationInstance
        :rtype: twilio.rest.verify.v2.service.verification.VerificationInstance
        """
        return VerificationInstance(self._version, payload, service_sid=self._solution['service_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Verify.V2.VerificationPage>'


class VerificationContext(InstanceContext):

    def __init__(self, version, service_sid, sid):
        """
        Initialize the VerificationContext

        :param Version version: Version that contains the resource
        :param service_sid: The SID of the verification Service to fetch the resource from
        :param sid: The unique string that identifies the resource

        :returns: twilio.rest.verify.v2.service.verification.VerificationContext
        :rtype: twilio.rest.verify.v2.service.verification.VerificationContext
        """
        super(VerificationContext, self).__init__(version)

        # Path Solution
        self._solution = {'service_sid': service_sid, 'sid': sid, }
        self._uri = '/Services/{service_sid}/Verifications/{sid}'.format(**self._solution)

    def update(self, status):
        """
        Update the VerificationInstance

        :param VerificationInstance.Status status: The new status of the resource

        :returns: The updated VerificationInstance
        :rtype: twilio.rest.verify.v2.service.verification.VerificationInstance
        """
        data = values.of({'Status': status, })

        payload = self._version.update(method='POST', uri=self._uri, data=data, )

        return VerificationInstance(
            self._version,
            payload,
            service_sid=self._solution['service_sid'],
            sid=self._solution['sid'],
        )

    def fetch(self):
        """
        Fetch the VerificationInstance

        :returns: The fetched VerificationInstance
        :rtype: twilio.rest.verify.v2.service.verification.VerificationInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return VerificationInstance(
            self._version,
            payload,
            service_sid=self._solution['service_sid'],
            sid=self._solution['sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Verify.V2.VerificationContext {}>'.format(context)


class VerificationInstance(InstanceResource):

    class Channel(object):
        SMS = "sms"
        CALL = "call"
        EMAIL = "email"
        WHATSAPP = "whatsapp"
        SNA = "sna"

    class Status(object):
        CANCELED = "canceled"
        APPROVED = "approved"

    def __init__(self, version, payload, service_sid, sid=None):
        """
        Initialize the VerificationInstance

        :returns: twilio.rest.verify.v2.service.verification.VerificationInstance
        :rtype: twilio.rest.verify.v2.service.verification.VerificationInstance
        """
        super(VerificationInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'sid': payload.get('sid'),
            'service_sid': payload.get('service_sid'),
            'account_sid': payload.get('account_sid'),
            'to': payload.get('to'),
            'channel': payload.get('channel'),
            'status': payload.get('status'),
            'valid': payload.get('valid'),
            'lookup': payload.get('lookup'),
            'amount': payload.get('amount'),
            'payee': payload.get('payee'),
            'send_code_attempts': payload.get('send_code_attempts'),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
            'sna': payload.get('sna'),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {'service_sid': service_sid, 'sid': sid or self._properties['sid'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: VerificationContext for this VerificationInstance
        :rtype: twilio.rest.verify.v2.service.verification.VerificationContext
        """
        if self._context is None:
            self._context = VerificationContext(
                self._version,
                service_sid=self._solution['service_sid'],
                sid=self._solution['sid'],
            )
        return self._context

    @property
    def sid(self):
        """
        :returns: The unique string that identifies the resource
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def service_sid(self):
        """
        :returns: The SID of the Service that the resource is associated with
        :rtype: unicode
        """
        return self._properties['service_sid']

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the resource
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def to(self):
        """
        :returns: The phone number or email being verified
        :rtype: unicode
        """
        return self._properties['to']

    @property
    def channel(self):
        """
        :returns: The verification method used.
        :rtype: VerificationInstance.Channel
        """
        return self._properties['channel']

    @property
    def status(self):
        """
        :returns: The status of the verification resource
        :rtype: unicode
        """
        return self._properties['status']

    @property
    def valid(self):
        """
        :returns: Whether the verification was successful
        :rtype: bool
        """
        return self._properties['valid']

    @property
    def lookup(self):
        """
        :returns: Information about the phone number being verified
        :rtype: dict
        """
        return self._properties['lookup']

    @property
    def amount(self):
        """
        :returns: The amount of the associated PSD2 compliant transaction.
        :rtype: unicode
        """
        return self._properties['amount']

    @property
    def payee(self):
        """
        :returns: The payee of the associated PSD2 compliant transaction
        :rtype: unicode
        """
        return self._properties['payee']

    @property
    def send_code_attempts(self):
        """
        :returns: An array of verification attempt objects.
        :rtype: list[dict]
        """
        return self._properties['send_code_attempts']

    @property
    def date_created(self):
        """
        :returns: The RFC 2822 date and time in GMT when the resource was created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The RFC 2822 date and time in GMT when the resource was last updated
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def sna(self):
        """
        :returns: The set of fields used for a silent network auth (`sna`) verification
        :rtype: dict
        """
        return self._properties['sna']

    @property
    def url(self):
        """
        :returns: The absolute URL of the Verification resource
        :rtype: unicode
        """
        return self._properties['url']

    def update(self, status):
        """
        Update the VerificationInstance

        :param VerificationInstance.Status status: The new status of the resource

        :returns: The updated VerificationInstance
        :rtype: twilio.rest.verify.v2.service.verification.VerificationInstance
        """
        return self._proxy.update(status, )

    def fetch(self):
        """
        Fetch the VerificationInstance

        :returns: The fetched VerificationInstance
        :rtype: twilio.rest.verify.v2.service.verification.VerificationInstance
        """
        return self._proxy.fetch()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Verify.V2.VerificationInstance {}>'.format(context)
