# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class SafelistList(ListResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version):
        """
        Initialize the SafelistList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.verify.v2.safelist.SafelistList
        :rtype: twilio.rest.verify.v2.safelist.SafelistList
        """
        super(SafelistList, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/SafeList/Numbers'.format(**self._solution)

    def create(self, phone_number):
        """
        Create the SafelistInstance

        :param unicode phone_number: The phone number to be added in SafeList.

        :returns: The created SafelistInstance
        :rtype: twilio.rest.verify.v2.safelist.SafelistInstance
        """
        data = values.of({'PhoneNumber': phone_number, })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return SafelistInstance(self._version, payload, )

    def get(self, phone_number):
        """
        Constructs a SafelistContext

        :param phone_number: The phone number to be fetched from SafeList.

        :returns: twilio.rest.verify.v2.safelist.SafelistContext
        :rtype: twilio.rest.verify.v2.safelist.SafelistContext
        """
        return SafelistContext(self._version, phone_number=phone_number, )

    def __call__(self, phone_number):
        """
        Constructs a SafelistContext

        :param phone_number: The phone number to be fetched from SafeList.

        :returns: twilio.rest.verify.v2.safelist.SafelistContext
        :rtype: twilio.rest.verify.v2.safelist.SafelistContext
        """
        return SafelistContext(self._version, phone_number=phone_number, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Verify.V2.SafelistList>'


class SafelistPage(Page):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, response, solution):
        """
        Initialize the SafelistPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.verify.v2.safelist.SafelistPage
        :rtype: twilio.rest.verify.v2.safelist.SafelistPage
        """
        super(SafelistPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of SafelistInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.verify.v2.safelist.SafelistInstance
        :rtype: twilio.rest.verify.v2.safelist.SafelistInstance
        """
        return SafelistInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Verify.V2.SafelistPage>'


class SafelistContext(InstanceContext):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, phone_number):
        """
        Initialize the SafelistContext

        :param Version version: Version that contains the resource
        :param phone_number: The phone number to be fetched from SafeList.

        :returns: twilio.rest.verify.v2.safelist.SafelistContext
        :rtype: twilio.rest.verify.v2.safelist.SafelistContext
        """
        super(SafelistContext, self).__init__(version)

        # Path Solution
        self._solution = {'phone_number': phone_number, }
        self._uri = '/SafeList/Numbers/{phone_number}'.format(**self._solution)

    def fetch(self):
        """
        Fetch the SafelistInstance

        :returns: The fetched SafelistInstance
        :rtype: twilio.rest.verify.v2.safelist.SafelistInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return SafelistInstance(self._version, payload, phone_number=self._solution['phone_number'], )

    def delete(self):
        """
        Deletes the SafelistInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._version.delete(method='DELETE', uri=self._uri, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Verify.V2.SafelistContext {}>'.format(context)


class SafelistInstance(InstanceResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, payload, phone_number=None):
        """
        Initialize the SafelistInstance

        :returns: twilio.rest.verify.v2.safelist.SafelistInstance
        :rtype: twilio.rest.verify.v2.safelist.SafelistInstance
        """
        super(SafelistInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'sid': payload.get('sid'),
            'phone_number': payload.get('phone_number'),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {'phone_number': phone_number or self._properties['phone_number'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: SafelistContext for this SafelistInstance
        :rtype: twilio.rest.verify.v2.safelist.SafelistContext
        """
        if self._context is None:
            self._context = SafelistContext(self._version, phone_number=self._solution['phone_number'], )
        return self._context

    @property
    def sid(self):
        """
        :returns: The unique string that identifies the resource.
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def phone_number(self):
        """
        :returns: The phone number in SafeList.
        :rtype: unicode
        """
        return self._properties['phone_number']

    @property
    def url(self):
        """
        :returns: The absolute URL of the SafeList resource.
        :rtype: unicode
        """
        return self._properties['url']

    def fetch(self):
        """
        Fetch the SafelistInstance

        :returns: The fetched SafelistInstance
        :rtype: twilio.rest.verify.v2.safelist.SafelistInstance
        """
        return self._proxy.fetch()

    def delete(self):
        """
        Deletes the SafelistInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._proxy.delete()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Verify.V2.SafelistInstance {}>'.format(context)
