# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import serialize
from twilio.base import values
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class DeviceCodeList(ListResource):

    def __init__(self, version):
        """
        Initialize the DeviceCodeList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.oauth.v1.device_code.DeviceCodeList
        :rtype: twilio.rest.oauth.v1.device_code.DeviceCodeList
        """
        super(DeviceCodeList, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/device/code'.format(**self._solution)

    def create(self, client_sid, scopes, audiences=values.unset):
        """
        Create the DeviceCodeInstance

        :param unicode client_sid: A string that uniquely identifies this oauth app
        :param list[unicode] scopes: An Array of scopes
        :param list[unicode] audiences: An array of intended audiences

        :returns: The created DeviceCodeInstance
        :rtype: twilio.rest.oauth.v1.device_code.DeviceCodeInstance
        """
        data = values.of({
            'ClientSid': client_sid,
            'Scopes': serialize.map(scopes, lambda e: e),
            'Audiences': serialize.map(audiences, lambda e: e),
        })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return DeviceCodeInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Oauth.V1.DeviceCodeList>'


class DeviceCodePage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the DeviceCodePage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.oauth.v1.device_code.DeviceCodePage
        :rtype: twilio.rest.oauth.v1.device_code.DeviceCodePage
        """
        super(DeviceCodePage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of DeviceCodeInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.oauth.v1.device_code.DeviceCodeInstance
        :rtype: twilio.rest.oauth.v1.device_code.DeviceCodeInstance
        """
        return DeviceCodeInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Oauth.V1.DeviceCodePage>'


class DeviceCodeInstance(InstanceResource):

    def __init__(self, version, payload):
        """
        Initialize the DeviceCodeInstance

        :returns: twilio.rest.oauth.v1.device_code.DeviceCodeInstance
        :rtype: twilio.rest.oauth.v1.device_code.DeviceCodeInstance
        """
        super(DeviceCodeInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'device_code': payload.get('device_code'),
            'user_code': payload.get('user_code'),
            'verification_uri': payload.get('verification_uri'),
            'verification_uri_complete': payload.get('verification_uri_complete'),
            'expires_in': deserialize.integer(payload.get('expires_in')),
            'interval': deserialize.integer(payload.get('interval')),
        }

        # Context
        self._context = None
        self._solution = {}

    @property
    def device_code(self):
        """
        :returns: The device verification code
        :rtype: unicode
        """
        return self._properties['device_code']

    @property
    def user_code(self):
        """
        :returns: The verification code for the end user
        :rtype: unicode
        """
        return self._properties['user_code']

    @property
    def verification_uri(self):
        """
        :returns: The URI that the end user visits to verify request
        :rtype: unicode
        """
        return self._properties['verification_uri']

    @property
    def verification_uri_complete(self):
        """
        :returns: he URI with user_code that the end-user alternatively visits to verify request
        :rtype: unicode
        """
        return self._properties['verification_uri_complete']

    @property
    def expires_in(self):
        """
        :returns: The expiration time of the device_code and user_code in seconds
        :rtype: unicode
        """
        return self._properties['expires_in']

    @property
    def interval(self):
        """
        :returns: The minimum amount of time in seconds that the client should wait between polling requests to the token endpoint
        :rtype: unicode
        """
        return self._properties['interval']

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Oauth.V1.DeviceCodeInstance>'
