# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.version import Version
from twilio.rest.oauth.v1.device_code import DeviceCodeList
from twilio.rest.oauth.v1.oauth import OauthList
from twilio.rest.oauth.v1.openid_discovery import OpenidDiscoveryList
from twilio.rest.oauth.v1.token import TokenList
from twilio.rest.oauth.v1.user_info import UserInfoList


class V1(Version):

    def __init__(self, domain):
        """
        Initialize the V1 version of Oauth

        :returns: V1 version of Oauth
        :rtype: twilio.rest.oauth.v1.V1.V1
        """
        super(V1, self).__init__(domain)
        self.version = 'v1'
        self._oauth = None
        self._device_code = None
        self._openid_discovery = None
        self._token = None
        self._user_info = None

    @property
    def oauth(self):
        """
        :rtype: twilio.rest.oauth.v1.oauth.OauthList
        """
        if self._oauth is None:
            self._oauth = OauthList(self)
        return self._oauth

    @property
    def device_code(self):
        """
        :rtype: twilio.rest.oauth.v1.device_code.DeviceCodeList
        """
        if self._device_code is None:
            self._device_code = DeviceCodeList(self)
        return self._device_code

    @property
    def openid_discovery(self):
        """
        :rtype: twilio.rest.oauth.v1.openid_discovery.OpenidDiscoveryList
        """
        if self._openid_discovery is None:
            self._openid_discovery = OpenidDiscoveryList(self)
        return self._openid_discovery

    @property
    def token(self):
        """
        :rtype: twilio.rest.oauth.v1.token.TokenList
        """
        if self._token is None:
            self._token = TokenList(self)
        return self._token

    @property
    def user_info(self):
        """
        :rtype: twilio.rest.oauth.v1.user_info.UserInfoList
        """
        if self._user_info is None:
            self._user_info = UserInfoList(self)
        return self._user_info

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Oauth.V1>'
