# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page
from twilio.rest.microvisor.v1.device.device_config import DeviceConfigList
from twilio.rest.microvisor.v1.device.device_secret import DeviceSecretList


class DeviceList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version):
        """
        Initialize the DeviceList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.microvisor.v1.device.DeviceList
        :rtype: twilio.rest.microvisor.v1.device.DeviceList
        """
        super(DeviceList, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/Devices'.format(**self._solution)

    def stream(self, limit=None, page_size=None):
        """
        Streams DeviceInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.microvisor.v1.device.DeviceInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(page_size=limits['page_size'], )

        return self._version.stream(page, limits['limit'])

    def list(self, limit=None, page_size=None):
        """
        Lists DeviceInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.microvisor.v1.device.DeviceInstance]
        """
        return list(self.stream(limit=limit, page_size=page_size, ))

    def page(self, page_token=values.unset, page_number=values.unset,
             page_size=values.unset):
        """
        Retrieve a single page of DeviceInstance records from the API.
        Request is executed immediately

        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of DeviceInstance
        :rtype: twilio.rest.microvisor.v1.device.DevicePage
        """
        data = values.of({'PageToken': page_token, 'Page': page_number, 'PageSize': page_size, })

        response = self._version.page(method='GET', uri=self._uri, params=data, )

        return DevicePage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of DeviceInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of DeviceInstance
        :rtype: twilio.rest.microvisor.v1.device.DevicePage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return DevicePage(self._version, response, self._solution)

    def get(self, sid):
        """
        Constructs a DeviceContext

        :param sid: A string that uniquely identifies this Device.

        :returns: twilio.rest.microvisor.v1.device.DeviceContext
        :rtype: twilio.rest.microvisor.v1.device.DeviceContext
        """
        return DeviceContext(self._version, sid=sid, )

    def __call__(self, sid):
        """
        Constructs a DeviceContext

        :param sid: A string that uniquely identifies this Device.

        :returns: twilio.rest.microvisor.v1.device.DeviceContext
        :rtype: twilio.rest.microvisor.v1.device.DeviceContext
        """
        return DeviceContext(self._version, sid=sid, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Microvisor.V1.DeviceList>'


class DevicePage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the DevicePage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.microvisor.v1.device.DevicePage
        :rtype: twilio.rest.microvisor.v1.device.DevicePage
        """
        super(DevicePage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of DeviceInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.microvisor.v1.device.DeviceInstance
        :rtype: twilio.rest.microvisor.v1.device.DeviceInstance
        """
        return DeviceInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Microvisor.V1.DevicePage>'


class DeviceContext(InstanceContext):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, sid):
        """
        Initialize the DeviceContext

        :param Version version: Version that contains the resource
        :param sid: A string that uniquely identifies this Device.

        :returns: twilio.rest.microvisor.v1.device.DeviceContext
        :rtype: twilio.rest.microvisor.v1.device.DeviceContext
        """
        super(DeviceContext, self).__init__(version)

        # Path Solution
        self._solution = {'sid': sid, }
        self._uri = '/Devices/{sid}'.format(**self._solution)

        # Dependents
        self._device_configs = None
        self._device_secrets = None

    def fetch(self):
        """
        Fetch the DeviceInstance

        :returns: The fetched DeviceInstance
        :rtype: twilio.rest.microvisor.v1.device.DeviceInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return DeviceInstance(self._version, payload, sid=self._solution['sid'], )

    def update(self, unique_name=values.unset, target_app=values.unset,
               logging_enabled=values.unset):
        """
        Update the DeviceInstance

        :param unicode unique_name: A unique, developer-assigned name for this Device.
        :param unicode target_app: The target App SID or unique name.
        :param bool logging_enabled: Whether to enable logging.

        :returns: The updated DeviceInstance
        :rtype: twilio.rest.microvisor.v1.device.DeviceInstance
        """
        data = values.of({
            'UniqueName': unique_name,
            'TargetApp': target_app,
            'LoggingEnabled': logging_enabled,
        })

        payload = self._version.update(method='POST', uri=self._uri, data=data, )

        return DeviceInstance(self._version, payload, sid=self._solution['sid'], )

    @property
    def device_configs(self):
        """
        Access the device_configs

        :returns: twilio.rest.microvisor.v1.device.device_config.DeviceConfigList
        :rtype: twilio.rest.microvisor.v1.device.device_config.DeviceConfigList
        """
        if self._device_configs is None:
            self._device_configs = DeviceConfigList(self._version, device_sid=self._solution['sid'], )
        return self._device_configs

    @property
    def device_secrets(self):
        """
        Access the device_secrets

        :returns: twilio.rest.microvisor.v1.device.device_secret.DeviceSecretList
        :rtype: twilio.rest.microvisor.v1.device.device_secret.DeviceSecretList
        """
        if self._device_secrets is None:
            self._device_secrets = DeviceSecretList(self._version, device_sid=self._solution['sid'], )
        return self._device_secrets

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Microvisor.V1.DeviceContext {}>'.format(context)


class DeviceInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload, sid=None):
        """
        Initialize the DeviceInstance

        :returns: twilio.rest.microvisor.v1.device.DeviceInstance
        :rtype: twilio.rest.microvisor.v1.device.DeviceInstance
        """
        super(DeviceInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'sid': payload.get('sid'),
            'unique_name': payload.get('unique_name'),
            'account_sid': payload.get('account_sid'),
            'app': payload.get('app'),
            'logging': payload.get('logging'),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
            'url': payload.get('url'),
            'links': payload.get('links'),
        }

        # Context
        self._context = None
        self._solution = {'sid': sid or self._properties['sid'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: DeviceContext for this DeviceInstance
        :rtype: twilio.rest.microvisor.v1.device.DeviceContext
        """
        if self._context is None:
            self._context = DeviceContext(self._version, sid=self._solution['sid'], )
        return self._context

    @property
    def sid(self):
        """
        :returns: A string that uniquely identifies this Device.
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def unique_name(self):
        """
        :returns: A developer-defined string that uniquely identifies the Device.
        :rtype: unicode
        """
        return self._properties['unique_name']

    @property
    def account_sid(self):
        """
        :returns: Account SID.
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def app(self):
        """
        :returns: Information about the target App and the App reported by this Device.
        :rtype: dict
        """
        return self._properties['app']

    @property
    def logging(self):
        """
        :returns: Object specifying whether application logging is enabled for this Device.
        :rtype: dict
        """
        return self._properties['logging']

    @property
    def date_created(self):
        """
        :returns: The date that this Device was created.
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The date that this Device was last updated.
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def url(self):
        """
        :returns: The URL of this resource.
        :rtype: unicode
        """
        return self._properties['url']

    @property
    def links(self):
        """
        :returns: The absolute URLs of related resources
        :rtype: unicode
        """
        return self._properties['links']

    def fetch(self):
        """
        Fetch the DeviceInstance

        :returns: The fetched DeviceInstance
        :rtype: twilio.rest.microvisor.v1.device.DeviceInstance
        """
        return self._proxy.fetch()

    def update(self, unique_name=values.unset, target_app=values.unset,
               logging_enabled=values.unset):
        """
        Update the DeviceInstance

        :param unicode unique_name: A unique, developer-assigned name for this Device.
        :param unicode target_app: The target App SID or unique name.
        :param bool logging_enabled: Whether to enable logging.

        :returns: The updated DeviceInstance
        :rtype: twilio.rest.microvisor.v1.device.DeviceInstance
        """
        return self._proxy.update(
            unique_name=unique_name,
            target_app=target_app,
            logging_enabled=logging_enabled,
        )

    @property
    def device_configs(self):
        """
        Access the device_configs

        :returns: twilio.rest.microvisor.v1.device.device_config.DeviceConfigList
        :rtype: twilio.rest.microvisor.v1.device.device_config.DeviceConfigList
        """
        return self._proxy.device_configs

    @property
    def device_secrets(self):
        """
        Access the device_secrets

        :returns: twilio.rest.microvisor.v1.device.device_secret.DeviceSecretList
        :rtype: twilio.rest.microvisor.v1.device.device_secret.DeviceSecretList
        """
        return self._proxy.device_secrets

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Microvisor.V1.DeviceInstance {}>'.format(context)
