# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class AppManifestList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, app_sid):
        """
        Initialize the AppManifestList

        :param Version version: Version that contains the resource
        :param app_sid: A string that uniquely identifies this App.

        :returns: twilio.rest.microvisor.v1.app.app_manifest.AppManifestList
        :rtype: twilio.rest.microvisor.v1.app.app_manifest.AppManifestList
        """
        super(AppManifestList, self).__init__(version)

        # Path Solution
        self._solution = {'app_sid': app_sid, }

    def get(self):
        """
        Constructs a AppManifestContext

        :returns: twilio.rest.microvisor.v1.app.app_manifest.AppManifestContext
        :rtype: twilio.rest.microvisor.v1.app.app_manifest.AppManifestContext
        """
        return AppManifestContext(self._version, app_sid=self._solution['app_sid'], )

    def __call__(self):
        """
        Constructs a AppManifestContext

        :returns: twilio.rest.microvisor.v1.app.app_manifest.AppManifestContext
        :rtype: twilio.rest.microvisor.v1.app.app_manifest.AppManifestContext
        """
        return AppManifestContext(self._version, app_sid=self._solution['app_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Microvisor.V1.AppManifestList>'


class AppManifestPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the AppManifestPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param app_sid: A string that uniquely identifies this App.

        :returns: twilio.rest.microvisor.v1.app.app_manifest.AppManifestPage
        :rtype: twilio.rest.microvisor.v1.app.app_manifest.AppManifestPage
        """
        super(AppManifestPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of AppManifestInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.microvisor.v1.app.app_manifest.AppManifestInstance
        :rtype: twilio.rest.microvisor.v1.app.app_manifest.AppManifestInstance
        """
        return AppManifestInstance(self._version, payload, app_sid=self._solution['app_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Microvisor.V1.AppManifestPage>'


class AppManifestContext(InstanceContext):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, app_sid):
        """
        Initialize the AppManifestContext

        :param Version version: Version that contains the resource
        :param app_sid: A string that uniquely identifies this App.

        :returns: twilio.rest.microvisor.v1.app.app_manifest.AppManifestContext
        :rtype: twilio.rest.microvisor.v1.app.app_manifest.AppManifestContext
        """
        super(AppManifestContext, self).__init__(version)

        # Path Solution
        self._solution = {'app_sid': app_sid, }
        self._uri = '/Apps/{app_sid}/Manifest'.format(**self._solution)

    def fetch(self):
        """
        Fetch the AppManifestInstance

        :returns: The fetched AppManifestInstance
        :rtype: twilio.rest.microvisor.v1.app.app_manifest.AppManifestInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return AppManifestInstance(self._version, payload, app_sid=self._solution['app_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Microvisor.V1.AppManifestContext {}>'.format(context)


class AppManifestInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload, app_sid):
        """
        Initialize the AppManifestInstance

        :returns: twilio.rest.microvisor.v1.app.app_manifest.AppManifestInstance
        :rtype: twilio.rest.microvisor.v1.app.app_manifest.AppManifestInstance
        """
        super(AppManifestInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'app_sid': payload.get('app_sid'),
            'hash': payload.get('hash'),
            'encoded_bytes': payload.get('encoded_bytes'),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {'app_sid': app_sid, }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: AppManifestContext for this AppManifestInstance
        :rtype: twilio.rest.microvisor.v1.app.app_manifest.AppManifestContext
        """
        if self._context is None:
            self._context = AppManifestContext(self._version, app_sid=self._solution['app_sid'], )
        return self._context

    @property
    def app_sid(self):
        """
        :returns: A string that uniquely identifies this App.
        :rtype: unicode
        """
        return self._properties['app_sid']

    @property
    def hash(self):
        """
        :returns: App manifest hash represented as hash_algorithm:hash_value.
        :rtype: unicode
        """
        return self._properties['hash']

    @property
    def encoded_bytes(self):
        """
        :returns: The base-64 encoded manifest
        :rtype: unicode
        """
        return self._properties['encoded_bytes']

    @property
    def url(self):
        """
        :returns: The absolute URL of this Manifest.
        :rtype: unicode
        """
        return self._properties['url']

    def fetch(self):
        """
        Fetch the AppManifestInstance

        :returns: The fetched AppManifestInstance
        :rtype: twilio.rest.microvisor.v1.app.app_manifest.AppManifestInstance
        """
        return self._proxy.fetch()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Microvisor.V1.AppManifestInstance {}>'.format(context)
