# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.version import Version
from twilio.rest.microvisor.v1.account_config import AccountConfigList
from twilio.rest.microvisor.v1.account_secret import AccountSecretList
from twilio.rest.microvisor.v1.app import AppList
from twilio.rest.microvisor.v1.device import DeviceList


class V1(Version):

    def __init__(self, domain):
        """
        Initialize the V1 version of Microvisor

        :returns: V1 version of Microvisor
        :rtype: twilio.rest.microvisor.v1.V1.V1
        """
        super(V1, self).__init__(domain)
        self.version = 'v1'
        self._account_configs = None
        self._account_secrets = None
        self._apps = None
        self._devices = None

    @property
    def account_configs(self):
        """
        :rtype: twilio.rest.microvisor.v1.account_config.AccountConfigList
        """
        if self._account_configs is None:
            self._account_configs = AccountConfigList(self)
        return self._account_configs

    @property
    def account_secrets(self):
        """
        :rtype: twilio.rest.microvisor.v1.account_secret.AccountSecretList
        """
        if self._account_secrets is None:
            self._account_secrets = AccountSecretList(self)
        return self._account_secrets

    @property
    def apps(self):
        """
        :rtype: twilio.rest.microvisor.v1.app.AppList
        """
        if self._apps is None:
            self._apps = AppList(self)
        return self._apps

    @property
    def devices(self):
        """
        :rtype: twilio.rest.microvisor.v1.device.DeviceList
        """
        if self._devices is None:
            self._devices = DeviceList(self)
        return self._devices

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Microvisor.V1>'
