# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class LinkshorteningMessagingServiceList(ListResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version):
        """
        Initialize the LinkshorteningMessagingServiceList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.messaging.v1.linkshortening_messaging_service.LinkshorteningMessagingServiceList
        :rtype: twilio.rest.messaging.v1.linkshortening_messaging_service.LinkshorteningMessagingServiceList
        """
        super(LinkshorteningMessagingServiceList, self).__init__(version)

        # Path Solution
        self._solution = {}

    def get(self, domain_sid, messaging_service_sid):
        """
        Constructs a LinkshorteningMessagingServiceContext

        :param domain_sid: The domain SID to dissociate from a messaging service
        :param messaging_service_sid: A messaging service SID to dissociate from a domain

        :returns: twilio.rest.messaging.v1.linkshortening_messaging_service.LinkshorteningMessagingServiceContext
        :rtype: twilio.rest.messaging.v1.linkshortening_messaging_service.LinkshorteningMessagingServiceContext
        """
        return LinkshorteningMessagingServiceContext(
            self._version,
            domain_sid=domain_sid,
            messaging_service_sid=messaging_service_sid,
        )

    def __call__(self, domain_sid, messaging_service_sid):
        """
        Constructs a LinkshorteningMessagingServiceContext

        :param domain_sid: The domain SID to dissociate from a messaging service
        :param messaging_service_sid: A messaging service SID to dissociate from a domain

        :returns: twilio.rest.messaging.v1.linkshortening_messaging_service.LinkshorteningMessagingServiceContext
        :rtype: twilio.rest.messaging.v1.linkshortening_messaging_service.LinkshorteningMessagingServiceContext
        """
        return LinkshorteningMessagingServiceContext(
            self._version,
            domain_sid=domain_sid,
            messaging_service_sid=messaging_service_sid,
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Messaging.V1.LinkshorteningMessagingServiceList>'


class LinkshorteningMessagingServicePage(Page):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, response, solution):
        """
        Initialize the LinkshorteningMessagingServicePage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.messaging.v1.linkshortening_messaging_service.LinkshorteningMessagingServicePage
        :rtype: twilio.rest.messaging.v1.linkshortening_messaging_service.LinkshorteningMessagingServicePage
        """
        super(LinkshorteningMessagingServicePage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of LinkshorteningMessagingServiceInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.messaging.v1.linkshortening_messaging_service.LinkshorteningMessagingServiceInstance
        :rtype: twilio.rest.messaging.v1.linkshortening_messaging_service.LinkshorteningMessagingServiceInstance
        """
        return LinkshorteningMessagingServiceInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Messaging.V1.LinkshorteningMessagingServicePage>'


class LinkshorteningMessagingServiceContext(InstanceContext):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, domain_sid, messaging_service_sid):
        """
        Initialize the LinkshorteningMessagingServiceContext

        :param Version version: Version that contains the resource
        :param domain_sid: The domain SID to dissociate from a messaging service
        :param messaging_service_sid: A messaging service SID to dissociate from a domain

        :returns: twilio.rest.messaging.v1.linkshortening_messaging_service.LinkshorteningMessagingServiceContext
        :rtype: twilio.rest.messaging.v1.linkshortening_messaging_service.LinkshorteningMessagingServiceContext
        """
        super(LinkshorteningMessagingServiceContext, self).__init__(version)

        # Path Solution
        self._solution = {'domain_sid': domain_sid, 'messaging_service_sid': messaging_service_sid, }
        self._uri = '/LinkShortening/Domains/{domain_sid}/MessagingServices/{messaging_service_sid}'.format(**self._solution)

    def create(self):
        """
        Create the LinkshorteningMessagingServiceInstance

        :returns: The created LinkshorteningMessagingServiceInstance
        :rtype: twilio.rest.messaging.v1.linkshortening_messaging_service.LinkshorteningMessagingServiceInstance
        """
        payload = self._version.create(method='POST', uri=self._uri, )

        return LinkshorteningMessagingServiceInstance(
            self._version,
            payload,
            domain_sid=self._solution['domain_sid'],
            messaging_service_sid=self._solution['messaging_service_sid'],
        )

    def delete(self):
        """
        Deletes the LinkshorteningMessagingServiceInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._version.delete(method='DELETE', uri=self._uri, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Messaging.V1.LinkshorteningMessagingServiceContext {}>'.format(context)


class LinkshorteningMessagingServiceInstance(InstanceResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, payload, domain_sid=None,
                 messaging_service_sid=None):
        """
        Initialize the LinkshorteningMessagingServiceInstance

        :returns: twilio.rest.messaging.v1.linkshortening_messaging_service.LinkshorteningMessagingServiceInstance
        :rtype: twilio.rest.messaging.v1.linkshortening_messaging_service.LinkshorteningMessagingServiceInstance
        """
        super(LinkshorteningMessagingServiceInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'domain_sid': payload.get('domain_sid'),
            'messaging_service_sid': payload.get('messaging_service_sid'),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {
            'domain_sid': domain_sid or self._properties['domain_sid'],
            'messaging_service_sid': messaging_service_sid or self._properties['messaging_service_sid'],
        }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: LinkshorteningMessagingServiceContext for this LinkshorteningMessagingServiceInstance
        :rtype: twilio.rest.messaging.v1.linkshortening_messaging_service.LinkshorteningMessagingServiceContext
        """
        if self._context is None:
            self._context = LinkshorteningMessagingServiceContext(
                self._version,
                domain_sid=self._solution['domain_sid'],
                messaging_service_sid=self._solution['messaging_service_sid'],
            )
        return self._context

    @property
    def domain_sid(self):
        """
        :returns: The unique string that identifies the domain resource
        :rtype: unicode
        """
        return self._properties['domain_sid']

    @property
    def messaging_service_sid(self):
        """
        :returns: The unique string that identifies the messaging service
        :rtype: unicode
        """
        return self._properties['messaging_service_sid']

    @property
    def url(self):
        """
        :returns: The url
        :rtype: unicode
        """
        return self._properties['url']

    def create(self):
        """
        Create the LinkshorteningMessagingServiceInstance

        :returns: The created LinkshorteningMessagingServiceInstance
        :rtype: twilio.rest.messaging.v1.linkshortening_messaging_service.LinkshorteningMessagingServiceInstance
        """
        return self._proxy.create()

    def delete(self):
        """
        Deletes the LinkshorteningMessagingServiceInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._proxy.delete()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Messaging.V1.LinkshorteningMessagingServiceInstance {}>'.format(context)
