# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class DomainConfigMessagingServiceList(ListResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version):
        """
        Initialize the DomainConfigMessagingServiceList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.messaging.v1.domain_config_messaging_service.DomainConfigMessagingServiceList
        :rtype: twilio.rest.messaging.v1.domain_config_messaging_service.DomainConfigMessagingServiceList
        """
        super(DomainConfigMessagingServiceList, self).__init__(version)

        # Path Solution
        self._solution = {}

    def get(self, messaging_service_sid):
        """
        Constructs a DomainConfigMessagingServiceContext

        :param messaging_service_sid: Unique string used to identify the Messaging service that this domain should be associated with.

        :returns: twilio.rest.messaging.v1.domain_config_messaging_service.DomainConfigMessagingServiceContext
        :rtype: twilio.rest.messaging.v1.domain_config_messaging_service.DomainConfigMessagingServiceContext
        """
        return DomainConfigMessagingServiceContext(
            self._version,
            messaging_service_sid=messaging_service_sid,
        )

    def __call__(self, messaging_service_sid):
        """
        Constructs a DomainConfigMessagingServiceContext

        :param messaging_service_sid: Unique string used to identify the Messaging service that this domain should be associated with.

        :returns: twilio.rest.messaging.v1.domain_config_messaging_service.DomainConfigMessagingServiceContext
        :rtype: twilio.rest.messaging.v1.domain_config_messaging_service.DomainConfigMessagingServiceContext
        """
        return DomainConfigMessagingServiceContext(
            self._version,
            messaging_service_sid=messaging_service_sid,
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Messaging.V1.DomainConfigMessagingServiceList>'


class DomainConfigMessagingServicePage(Page):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, response, solution):
        """
        Initialize the DomainConfigMessagingServicePage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.messaging.v1.domain_config_messaging_service.DomainConfigMessagingServicePage
        :rtype: twilio.rest.messaging.v1.domain_config_messaging_service.DomainConfigMessagingServicePage
        """
        super(DomainConfigMessagingServicePage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of DomainConfigMessagingServiceInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.messaging.v1.domain_config_messaging_service.DomainConfigMessagingServiceInstance
        :rtype: twilio.rest.messaging.v1.domain_config_messaging_service.DomainConfigMessagingServiceInstance
        """
        return DomainConfigMessagingServiceInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Messaging.V1.DomainConfigMessagingServicePage>'


class DomainConfigMessagingServiceContext(InstanceContext):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, messaging_service_sid):
        """
        Initialize the DomainConfigMessagingServiceContext

        :param Version version: Version that contains the resource
        :param messaging_service_sid: Unique string used to identify the Messaging service that this domain should be associated with.

        :returns: twilio.rest.messaging.v1.domain_config_messaging_service.DomainConfigMessagingServiceContext
        :rtype: twilio.rest.messaging.v1.domain_config_messaging_service.DomainConfigMessagingServiceContext
        """
        super(DomainConfigMessagingServiceContext, self).__init__(version)

        # Path Solution
        self._solution = {'messaging_service_sid': messaging_service_sid, }
        self._uri = '/LinkShortening/MessagingService/{messaging_service_sid}/DomainConfig'.format(**self._solution)

    def fetch(self):
        """
        Fetch the DomainConfigMessagingServiceInstance

        :returns: The fetched DomainConfigMessagingServiceInstance
        :rtype: twilio.rest.messaging.v1.domain_config_messaging_service.DomainConfigMessagingServiceInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return DomainConfigMessagingServiceInstance(
            self._version,
            payload,
            messaging_service_sid=self._solution['messaging_service_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Messaging.V1.DomainConfigMessagingServiceContext {}>'.format(context)


class DomainConfigMessagingServiceInstance(InstanceResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, payload, messaging_service_sid=None):
        """
        Initialize the DomainConfigMessagingServiceInstance

        :returns: twilio.rest.messaging.v1.domain_config_messaging_service.DomainConfigMessagingServiceInstance
        :rtype: twilio.rest.messaging.v1.domain_config_messaging_service.DomainConfigMessagingServiceInstance
        """
        super(DomainConfigMessagingServiceInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'domain_sid': payload.get('domain_sid'),
            'config_sid': payload.get('config_sid'),
            'messaging_service_sid': payload.get('messaging_service_sid'),
            'fallback_url': payload.get('fallback_url'),
            'callback_url': payload.get('callback_url'),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {
            'messaging_service_sid': messaging_service_sid or self._properties['messaging_service_sid'],
        }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: DomainConfigMessagingServiceContext for this DomainConfigMessagingServiceInstance
        :rtype: twilio.rest.messaging.v1.domain_config_messaging_service.DomainConfigMessagingServiceContext
        """
        if self._context is None:
            self._context = DomainConfigMessagingServiceContext(
                self._version,
                messaging_service_sid=self._solution['messaging_service_sid'],
            )
        return self._context

    @property
    def domain_sid(self):
        """
        :returns: The unique string that we created to identify the Domain resource.
        :rtype: unicode
        """
        return self._properties['domain_sid']

    @property
    def config_sid(self):
        """
        :returns: The unique string that we created to identify the Domain config (prefix ZK).
        :rtype: unicode
        """
        return self._properties['config_sid']

    @property
    def messaging_service_sid(self):
        """
        :returns: The unique string that identifies the messaging service
        :rtype: unicode
        """
        return self._properties['messaging_service_sid']

    @property
    def fallback_url(self):
        """
        :returns: We will redirect requests to urls we are unable to identify to this url.
        :rtype: unicode
        """
        return self._properties['fallback_url']

    @property
    def callback_url(self):
        """
        :returns: URL to receive click events to your webhook whenever the recipients click on the shortened links.
        :rtype: unicode
        """
        return self._properties['callback_url']

    @property
    def date_created(self):
        """
        :returns: Date this Domain Config was created.
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: Date that this Domain Config was last updated.
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def url(self):
        """
        :returns: The url
        :rtype: unicode
        """
        return self._properties['url']

    def fetch(self):
        """
        Fetch the DomainConfigMessagingServiceInstance

        :returns: The fetched DomainConfigMessagingServiceInstance
        :rtype: twilio.rest.messaging.v1.domain_config_messaging_service.DomainConfigMessagingServiceInstance
        """
        return self._proxy.fetch()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Messaging.V1.DomainConfigMessagingServiceInstance {}>'.format(context)
