# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class PhoneNumberList(ListResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version):
        """
        Initialize the PhoneNumberList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.lookups.v2.phone_number.PhoneNumberList
        :rtype: twilio.rest.lookups.v2.phone_number.PhoneNumberList
        """
        super(PhoneNumberList, self).__init__(version)

        # Path Solution
        self._solution = {}

    def get(self, phone_number):
        """
        Constructs a PhoneNumberContext

        :param phone_number: Phone number to lookup

        :returns: twilio.rest.lookups.v2.phone_number.PhoneNumberContext
        :rtype: twilio.rest.lookups.v2.phone_number.PhoneNumberContext
        """
        return PhoneNumberContext(self._version, phone_number=phone_number, )

    def __call__(self, phone_number):
        """
        Constructs a PhoneNumberContext

        :param phone_number: Phone number to lookup

        :returns: twilio.rest.lookups.v2.phone_number.PhoneNumberContext
        :rtype: twilio.rest.lookups.v2.phone_number.PhoneNumberContext
        """
        return PhoneNumberContext(self._version, phone_number=phone_number, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Lookups.V2.PhoneNumberList>'


class PhoneNumberPage(Page):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, response, solution):
        """
        Initialize the PhoneNumberPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.lookups.v2.phone_number.PhoneNumberPage
        :rtype: twilio.rest.lookups.v2.phone_number.PhoneNumberPage
        """
        super(PhoneNumberPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of PhoneNumberInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.lookups.v2.phone_number.PhoneNumberInstance
        :rtype: twilio.rest.lookups.v2.phone_number.PhoneNumberInstance
        """
        return PhoneNumberInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Lookups.V2.PhoneNumberPage>'


class PhoneNumberContext(InstanceContext):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, phone_number):
        """
        Initialize the PhoneNumberContext

        :param Version version: Version that contains the resource
        :param phone_number: Phone number to lookup

        :returns: twilio.rest.lookups.v2.phone_number.PhoneNumberContext
        :rtype: twilio.rest.lookups.v2.phone_number.PhoneNumberContext
        """
        super(PhoneNumberContext, self).__init__(version)

        # Path Solution
        self._solution = {'phone_number': phone_number, }
        self._uri = '/PhoneNumbers/{phone_number}'.format(**self._solution)

    def fetch(self, fields=values.unset, country_code=values.unset,
              first_name=values.unset, last_name=values.unset,
              address_line_1=values.unset, address_line_2=values.unset,
              city=values.unset, state=values.unset, postal_code=values.unset,
              address_country_code=values.unset, national_id=values.unset,
              date_of_birth=values.unset):
        """
        Fetch the PhoneNumberInstance

        :param unicode fields: Fields to return
        :param unicode country_code: Country code for national phone number lookups
        :param unicode first_name: User’s first name.
        :param unicode last_name: User’s last name.
        :param unicode address_line_1: User’s first address line.
        :param unicode address_line_2: User’s second address line.
        :param unicode city: User’s city.
        :param unicode state: User’s country subdivision, such as state, province, or locality.
        :param unicode postal_code: User’s postal zip code.
        :param unicode address_country_code: User’s country, up to two characters.
        :param unicode national_id: User’s national ID, such as SSN or Passport ID.
        :param unicode date_of_birth: User’s date of birth, in YYYYMMDD format.

        :returns: The fetched PhoneNumberInstance
        :rtype: twilio.rest.lookups.v2.phone_number.PhoneNumberInstance
        """
        data = values.of({
            'Fields': fields,
            'CountryCode': country_code,
            'FirstName': first_name,
            'LastName': last_name,
            'AddressLine1': address_line_1,
            'AddressLine2': address_line_2,
            'City': city,
            'State': state,
            'PostalCode': postal_code,
            'AddressCountryCode': address_country_code,
            'NationalId': national_id,
            'DateOfBirth': date_of_birth,
        })

        payload = self._version.fetch(method='GET', uri=self._uri, params=data, )

        return PhoneNumberInstance(self._version, payload, phone_number=self._solution['phone_number'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Lookups.V2.PhoneNumberContext {}>'.format(context)


class PhoneNumberInstance(InstanceResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    class Type(object):
        LANDLINE = "landline"
        MOBILE = "mobile"
        VOIP = "voip"

    class ValidationError(object):
        TOO_SHORT = "TOO_SHORT"
        TOO_LONG = "TOO_LONG"
        INVALID_BUT_POSSIBLE = "INVALID_BUT_POSSIBLE"
        INVALID_COUNTRY_CODE = "INVALID_COUNTRY_CODE"
        INVALID_LENGTH = "INVALID_LENGTH"
        NOT_A_NUMBER = "NOT_A_NUMBER"

    def __init__(self, version, payload, phone_number=None):
        """
        Initialize the PhoneNumberInstance

        :returns: twilio.rest.lookups.v2.phone_number.PhoneNumberInstance
        :rtype: twilio.rest.lookups.v2.phone_number.PhoneNumberInstance
        """
        super(PhoneNumberInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'calling_country_code': payload.get('calling_country_code'),
            'country_code': payload.get('country_code'),
            'phone_number': payload.get('phone_number'),
            'national_format': payload.get('national_format'),
            'valid': payload.get('valid'),
            'validation_errors': payload.get('validation_errors'),
            'caller_name': payload.get('caller_name'),
            'sim_swap': payload.get('sim_swap'),
            'call_forwarding': payload.get('call_forwarding'),
            'live_activity': payload.get('live_activity'),
            'line_type_intelligence': payload.get('line_type_intelligence'),
            'identity_match': payload.get('identity_match'),
            'sms_pumping_risk': payload.get('sms_pumping_risk'),
            'disposable_phone_number_risk': payload.get('disposable_phone_number_risk'),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {'phone_number': phone_number or self._properties['phone_number'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: PhoneNumberContext for this PhoneNumberInstance
        :rtype: twilio.rest.lookups.v2.phone_number.PhoneNumberContext
        """
        if self._context is None:
            self._context = PhoneNumberContext(self._version, phone_number=self._solution['phone_number'], )
        return self._context

    @property
    def calling_country_code(self):
        """
        :returns: International dialing prefix
        :rtype: unicode
        """
        return self._properties['calling_country_code']

    @property
    def country_code(self):
        """
        :returns: Phone number's ISO country code
        :rtype: unicode
        """
        return self._properties['country_code']

    @property
    def phone_number(self):
        """
        :returns: Phone number in E.164 format
        :rtype: unicode
        """
        return self._properties['phone_number']

    @property
    def national_format(self):
        """
        :returns: Phone number in national format
        :rtype: unicode
        """
        return self._properties['national_format']

    @property
    def valid(self):
        """
        :returns: Boolean which indicates if the phone number is valid
        :rtype: bool
        """
        return self._properties['valid']

    @property
    def validation_errors(self):
        """
        :returns: Contains reasons why a phone number is invalid
        :rtype: list[PhoneNumberInstance.ValidationError]
        """
        return self._properties['validation_errors']

    @property
    def caller_name(self):
        """
        :returns: An object that contains caller name information
        :rtype: dict
        """
        return self._properties['caller_name']

    @property
    def sim_swap(self):
        """
        :returns: An object that contains SIM swap information
        :rtype: dict
        """
        return self._properties['sim_swap']

    @property
    def call_forwarding(self):
        """
        :returns: An object that contains call forwarding status information
        :rtype: dict
        """
        return self._properties['call_forwarding']

    @property
    def live_activity(self):
        """
        :returns: An object that contains live activity information
        :rtype: dict
        """
        return self._properties['live_activity']

    @property
    def line_type_intelligence(self):
        """
        :returns: An object that contains line type information
        :rtype: dict
        """
        return self._properties['line_type_intelligence']

    @property
    def identity_match(self):
        """
        :returns: An object that contains identity match information
        :rtype: dict
        """
        return self._properties['identity_match']

    @property
    def sms_pumping_risk(self):
        """
        :returns: An object that contains sms pumping risk information
        :rtype: dict
        """
        return self._properties['sms_pumping_risk']

    @property
    def disposable_phone_number_risk(self):
        """
        :returns: An object that contains disposable phone number risk information
        :rtype: dict
        """
        return self._properties['disposable_phone_number_risk']

    @property
    def url(self):
        """
        :returns: The absolute URL of the resource
        :rtype: unicode
        """
        return self._properties['url']

    def fetch(self, fields=values.unset, country_code=values.unset,
              first_name=values.unset, last_name=values.unset,
              address_line_1=values.unset, address_line_2=values.unset,
              city=values.unset, state=values.unset, postal_code=values.unset,
              address_country_code=values.unset, national_id=values.unset,
              date_of_birth=values.unset):
        """
        Fetch the PhoneNumberInstance

        :param unicode fields: Fields to return
        :param unicode country_code: Country code for national phone number lookups
        :param unicode first_name: User’s first name.
        :param unicode last_name: User’s last name.
        :param unicode address_line_1: User’s first address line.
        :param unicode address_line_2: User’s second address line.
        :param unicode city: User’s city.
        :param unicode state: User’s country subdivision, such as state, province, or locality.
        :param unicode postal_code: User’s postal zip code.
        :param unicode address_country_code: User’s country, up to two characters.
        :param unicode national_id: User’s national ID, such as SSN or Passport ID.
        :param unicode date_of_birth: User’s date of birth, in YYYYMMDD format.

        :returns: The fetched PhoneNumberInstance
        :rtype: twilio.rest.lookups.v2.phone_number.PhoneNumberInstance
        """
        return self._proxy.fetch(
            fields=fields,
            country_code=country_code,
            first_name=first_name,
            last_name=last_name,
            address_line_1=address_line_1,
            address_line_2=address_line_2,
            city=city,
            state=state,
            postal_code=postal_code,
            address_country_code=address_country_code,
            national_id=national_id,
            date_of_birth=date_of_birth,
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Lookups.V2.PhoneNumberInstance {}>'.format(context)
