# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class InsightsUserRolesList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version):
        """
        Initialize the InsightsUserRolesList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.flex_api.v1.insights_user_roles.InsightsUserRolesList
        :rtype: twilio.rest.flex_api.v1.insights_user_roles.InsightsUserRolesList
        """
        super(InsightsUserRolesList, self).__init__(version)

        # Path Solution
        self._solution = {}

    def get(self):
        """
        Constructs a InsightsUserRolesContext

        :returns: twilio.rest.flex_api.v1.insights_user_roles.InsightsUserRolesContext
        :rtype: twilio.rest.flex_api.v1.insights_user_roles.InsightsUserRolesContext
        """
        return InsightsUserRolesContext(self._version, )

    def __call__(self):
        """
        Constructs a InsightsUserRolesContext

        :returns: twilio.rest.flex_api.v1.insights_user_roles.InsightsUserRolesContext
        :rtype: twilio.rest.flex_api.v1.insights_user_roles.InsightsUserRolesContext
        """
        return InsightsUserRolesContext(self._version, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.FlexApi.V1.InsightsUserRolesList>'


class InsightsUserRolesPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the InsightsUserRolesPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.flex_api.v1.insights_user_roles.InsightsUserRolesPage
        :rtype: twilio.rest.flex_api.v1.insights_user_roles.InsightsUserRolesPage
        """
        super(InsightsUserRolesPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of InsightsUserRolesInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.flex_api.v1.insights_user_roles.InsightsUserRolesInstance
        :rtype: twilio.rest.flex_api.v1.insights_user_roles.InsightsUserRolesInstance
        """
        return InsightsUserRolesInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.FlexApi.V1.InsightsUserRolesPage>'


class InsightsUserRolesContext(InstanceContext):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version):
        """
        Initialize the InsightsUserRolesContext

        :param Version version: Version that contains the resource

        :returns: twilio.rest.flex_api.v1.insights_user_roles.InsightsUserRolesContext
        :rtype: twilio.rest.flex_api.v1.insights_user_roles.InsightsUserRolesContext
        """
        super(InsightsUserRolesContext, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/Insights/UserRoles'.format(**self._solution)

    def fetch(self, authorization=values.unset):
        """
        Fetch the InsightsUserRolesInstance

        :param unicode authorization: The Authorization HTTP request header

        :returns: The fetched InsightsUserRolesInstance
        :rtype: twilio.rest.flex_api.v1.insights_user_roles.InsightsUserRolesInstance
        """
        headers = values.of({'Authorization': authorization, })

        payload = self._version.fetch(method='GET', uri=self._uri, headers=headers, )

        return InsightsUserRolesInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.FlexApi.V1.InsightsUserRolesContext {}>'.format(context)


class InsightsUserRolesInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload):
        """
        Initialize the InsightsUserRolesInstance

        :returns: twilio.rest.flex_api.v1.insights_user_roles.InsightsUserRolesInstance
        :rtype: twilio.rest.flex_api.v1.insights_user_roles.InsightsUserRolesInstance
        """
        super(InsightsUserRolesInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {'roles': payload.get('roles'), 'url': payload.get('url'), }

        # Context
        self._context = None
        self._solution = {}

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: InsightsUserRolesContext for this InsightsUserRolesInstance
        :rtype: twilio.rest.flex_api.v1.insights_user_roles.InsightsUserRolesContext
        """
        if self._context is None:
            self._context = InsightsUserRolesContext(self._version, )
        return self._context

    @property
    def roles(self):
        """
        :returns: Flex Insights roles for the user
        :rtype: list[unicode]
        """
        return self._properties['roles']

    @property
    def url(self):
        """
        :returns: The url
        :rtype: unicode
        """
        return self._properties['url']

    def fetch(self, authorization=values.unset):
        """
        Fetch the InsightsUserRolesInstance

        :param unicode authorization: The Authorization HTTP request header

        :returns: The fetched InsightsUserRolesInstance
        :rtype: twilio.rest.flex_api.v1.insights_user_roles.InsightsUserRolesInstance
        """
        return self._proxy.fetch(authorization=authorization, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.FlexApi.V1.InsightsUserRolesInstance {}>'.format(context)
