# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class InsightsSettingsAnswerSetsList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version):
        """
        Initialize the InsightsSettingsAnswerSetsList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.flex_api.v1.insights_settings_answersets.InsightsSettingsAnswerSetsList
        :rtype: twilio.rest.flex_api.v1.insights_settings_answersets.InsightsSettingsAnswerSetsList
        """
        super(InsightsSettingsAnswerSetsList, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/Insights/QM/Settings/AnswerSets'.format(**self._solution)

    def fetch(self, token=values.unset):
        """
        Fetch the InsightsSettingsAnswerSetsInstance

        :param unicode token: The Token HTTP request header

        :returns: The fetched InsightsSettingsAnswerSetsInstance
        :rtype: twilio.rest.flex_api.v1.insights_settings_answersets.InsightsSettingsAnswerSetsInstance
        """
        headers = values.of({'Token': token, })

        payload = self._version.fetch(method='GET', uri=self._uri, headers=headers, )

        return InsightsSettingsAnswerSetsInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.FlexApi.V1.InsightsSettingsAnswerSetsList>'


class InsightsSettingsAnswerSetsPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the InsightsSettingsAnswerSetsPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.flex_api.v1.insights_settings_answersets.InsightsSettingsAnswerSetsPage
        :rtype: twilio.rest.flex_api.v1.insights_settings_answersets.InsightsSettingsAnswerSetsPage
        """
        super(InsightsSettingsAnswerSetsPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of InsightsSettingsAnswerSetsInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.flex_api.v1.insights_settings_answersets.InsightsSettingsAnswerSetsInstance
        :rtype: twilio.rest.flex_api.v1.insights_settings_answersets.InsightsSettingsAnswerSetsInstance
        """
        return InsightsSettingsAnswerSetsInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.FlexApi.V1.InsightsSettingsAnswerSetsPage>'


class InsightsSettingsAnswerSetsInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload):
        """
        Initialize the InsightsSettingsAnswerSetsInstance

        :returns: twilio.rest.flex_api.v1.insights_settings_answersets.InsightsSettingsAnswerSetsInstance
        :rtype: twilio.rest.flex_api.v1.insights_settings_answersets.InsightsSettingsAnswerSetsInstance
        """
        super(InsightsSettingsAnswerSetsInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'answer_sets': payload.get('answer_sets'),
            'answer_set_categories': payload.get('answer_set_categories'),
            'not_applicable': payload.get('not_applicable'),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {}

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the resource and owns this Flex Insights
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def answer_sets(self):
        """
        :returns: Answer Set list
        :rtype: dict
        """
        return self._properties['answer_sets']

    @property
    def answer_set_categories(self):
        """
        :returns: Categories of Answer Set
        :rtype: dict
        """
        return self._properties['answer_set_categories']

    @property
    def not_applicable(self):
        """
        :returns: NA answer set
        :rtype: dict
        """
        return self._properties['not_applicable']

    @property
    def url(self):
        """
        :returns: The url
        :rtype: unicode
        """
        return self._properties['url']

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.FlexApi.V1.InsightsSettingsAnswerSetsInstance>'
