# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class InsightsConversationsList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version):
        """
        Initialize the InsightsConversationsList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.flex_api.v1.insights_conversations.InsightsConversationsList
        :rtype: twilio.rest.flex_api.v1.insights_conversations.InsightsConversationsList
        """
        super(InsightsConversationsList, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/Insights/Conversations'.format(**self._solution)

    def stream(self, segment_id=values.unset, token=values.unset, limit=None,
               page_size=None):
        """
        Streams InsightsConversationsInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param unicode segment_id: Unique Segment Id
        :param unicode token: The Token HTTP request header
        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.flex_api.v1.insights_conversations.InsightsConversationsInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(segment_id=segment_id, token=token, page_size=limits['page_size'], )

        return self._version.stream(page, limits['limit'])

    def list(self, segment_id=values.unset, token=values.unset, limit=None,
             page_size=None):
        """
        Lists InsightsConversationsInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param unicode segment_id: Unique Segment Id
        :param unicode token: The Token HTTP request header
        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.flex_api.v1.insights_conversations.InsightsConversationsInstance]
        """
        return list(self.stream(segment_id=segment_id, token=token, limit=limit, page_size=page_size, ))

    def page(self, segment_id=values.unset, token=values.unset,
             page_token=values.unset, page_number=values.unset,
             page_size=values.unset):
        """
        Retrieve a single page of InsightsConversationsInstance records from the API.
        Request is executed immediately

        :param unicode segment_id: Unique Segment Id
        :param unicode token: The Token HTTP request header
        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of InsightsConversationsInstance
        :rtype: twilio.rest.flex_api.v1.insights_conversations.InsightsConversationsPage
        """
        data = values.of({
            'SegmentId': segment_id,
            'PageToken': page_token,
            'Page': page_number,
            'PageSize': page_size,
        })
        headers = values.of({'Token': token, })

        response = self._version.page(method='GET', uri=self._uri, params=data, headers=headers, )

        return InsightsConversationsPage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of InsightsConversationsInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of InsightsConversationsInstance
        :rtype: twilio.rest.flex_api.v1.insights_conversations.InsightsConversationsPage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return InsightsConversationsPage(self._version, response, self._solution)

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.FlexApi.V1.InsightsConversationsList>'


class InsightsConversationsPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the InsightsConversationsPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.flex_api.v1.insights_conversations.InsightsConversationsPage
        :rtype: twilio.rest.flex_api.v1.insights_conversations.InsightsConversationsPage
        """
        super(InsightsConversationsPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of InsightsConversationsInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.flex_api.v1.insights_conversations.InsightsConversationsInstance
        :rtype: twilio.rest.flex_api.v1.insights_conversations.InsightsConversationsInstance
        """
        return InsightsConversationsInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.FlexApi.V1.InsightsConversationsPage>'


class InsightsConversationsInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload):
        """
        Initialize the InsightsConversationsInstance

        :returns: twilio.rest.flex_api.v1.insights_conversations.InsightsConversationsInstance
        :rtype: twilio.rest.flex_api.v1.insights_conversations.InsightsConversationsInstance
        """
        super(InsightsConversationsInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_id': payload.get('account_id'),
            'conversation_id': payload.get('conversation_id'),
            'segment_count': deserialize.integer(payload.get('segment_count')),
            'segments': payload.get('segments'),
        }

        # Context
        self._context = None
        self._solution = {}

    @property
    def account_id(self):
        """
        :returns: The account id
        :rtype: unicode
        """
        return self._properties['account_id']

    @property
    def conversation_id(self):
        """
        :returns: Unique conversation Id
        :rtype: unicode
        """
        return self._properties['conversation_id']

    @property
    def segment_count(self):
        """
        :returns: The segment count
        :rtype: unicode
        """
        return self._properties['segment_count']

    @property
    def segments(self):
        """
        :returns: The conversation segments
        :rtype: list[dict]
        """
        return self._properties['segments']

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.FlexApi.V1.InsightsConversationsInstance>'
