# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class InsightsAssessmentsCommentList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version):
        """
        Initialize the InsightsAssessmentsCommentList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.flex_api.v1.insights_assessments_comment.InsightsAssessmentsCommentList
        :rtype: twilio.rest.flex_api.v1.insights_assessments_comment.InsightsAssessmentsCommentList
        """
        super(InsightsAssessmentsCommentList, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/Insights/QM/Assessments/Comments'.format(**self._solution)

    def create(self, category_id, category_name, comment, segment_id, user_name,
               user_email, agent_id, offset, token=values.unset):
        """
        Create the InsightsAssessmentsCommentInstance

        :param unicode category_id: Category ID
        :param unicode category_name: Category name
        :param unicode comment: The comment.
        :param unicode segment_id: Segment Id.
        :param unicode user_name: The user name.
        :param unicode user_email: The user email id.
        :param unicode agent_id: Agent Id.
        :param unicode offset: Offset.
        :param unicode token: The Token HTTP request header

        :returns: The created InsightsAssessmentsCommentInstance
        :rtype: twilio.rest.flex_api.v1.insights_assessments_comment.InsightsAssessmentsCommentInstance
        """
        data = values.of({
            'CategoryId': category_id,
            'CategoryName': category_name,
            'Comment': comment,
            'SegmentId': segment_id,
            'UserName': user_name,
            'UserEmail': user_email,
            'AgentId': agent_id,
            'Offset': offset,
        })
        headers = values.of({'Token': token, })

        payload = self._version.create(method='POST', uri=self._uri, data=data, headers=headers, )

        return InsightsAssessmentsCommentInstance(self._version, payload, )

    def stream(self, segment_id=values.unset, agent_id=values.unset,
               token=values.unset, limit=None, page_size=None):
        """
        Streams InsightsAssessmentsCommentInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param unicode segment_id: Segment Id.
        :param unicode agent_id: Agent Id.
        :param unicode token: The Token HTTP request header
        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.flex_api.v1.insights_assessments_comment.InsightsAssessmentsCommentInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(
            segment_id=segment_id,
            agent_id=agent_id,
            token=token,
            page_size=limits['page_size'],
        )

        return self._version.stream(page, limits['limit'])

    def list(self, segment_id=values.unset, agent_id=values.unset,
             token=values.unset, limit=None, page_size=None):
        """
        Lists InsightsAssessmentsCommentInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param unicode segment_id: Segment Id.
        :param unicode agent_id: Agent Id.
        :param unicode token: The Token HTTP request header
        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.flex_api.v1.insights_assessments_comment.InsightsAssessmentsCommentInstance]
        """
        return list(self.stream(
            segment_id=segment_id,
            agent_id=agent_id,
            token=token,
            limit=limit,
            page_size=page_size,
        ))

    def page(self, segment_id=values.unset, agent_id=values.unset,
             token=values.unset, page_token=values.unset, page_number=values.unset,
             page_size=values.unset):
        """
        Retrieve a single page of InsightsAssessmentsCommentInstance records from the API.
        Request is executed immediately

        :param unicode segment_id: Segment Id.
        :param unicode agent_id: Agent Id.
        :param unicode token: The Token HTTP request header
        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of InsightsAssessmentsCommentInstance
        :rtype: twilio.rest.flex_api.v1.insights_assessments_comment.InsightsAssessmentsCommentPage
        """
        data = values.of({
            'SegmentId': segment_id,
            'AgentId': agent_id,
            'PageToken': page_token,
            'Page': page_number,
            'PageSize': page_size,
        })
        headers = values.of({'Token': token, })

        response = self._version.page(method='GET', uri=self._uri, params=data, headers=headers, )

        return InsightsAssessmentsCommentPage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of InsightsAssessmentsCommentInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of InsightsAssessmentsCommentInstance
        :rtype: twilio.rest.flex_api.v1.insights_assessments_comment.InsightsAssessmentsCommentPage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return InsightsAssessmentsCommentPage(self._version, response, self._solution)

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.FlexApi.V1.InsightsAssessmentsCommentList>'


class InsightsAssessmentsCommentPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the InsightsAssessmentsCommentPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.flex_api.v1.insights_assessments_comment.InsightsAssessmentsCommentPage
        :rtype: twilio.rest.flex_api.v1.insights_assessments_comment.InsightsAssessmentsCommentPage
        """
        super(InsightsAssessmentsCommentPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of InsightsAssessmentsCommentInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.flex_api.v1.insights_assessments_comment.InsightsAssessmentsCommentInstance
        :rtype: twilio.rest.flex_api.v1.insights_assessments_comment.InsightsAssessmentsCommentInstance
        """
        return InsightsAssessmentsCommentInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.FlexApi.V1.InsightsAssessmentsCommentPage>'


class InsightsAssessmentsCommentInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload):
        """
        Initialize the InsightsAssessmentsCommentInstance

        :returns: twilio.rest.flex_api.v1.insights_assessments_comment.InsightsAssessmentsCommentInstance
        :rtype: twilio.rest.flex_api.v1.insights_assessments_comment.InsightsAssessmentsCommentInstance
        """
        super(InsightsAssessmentsCommentInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'assessment_id': payload.get('assessment_id'),
            'comment': payload.get('comment'),
            'offset': deserialize.decimal(payload.get('offset')),
            'report': payload.get('report'),
            'weight': deserialize.decimal(payload.get('weight')),
            'agent_id': payload.get('agent_id'),
            'segment_id': payload.get('segment_id'),
            'user_name': payload.get('user_name'),
            'user_email': payload.get('user_email'),
            'timestamp': deserialize.decimal(payload.get('timestamp')),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {}

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the resource and owns this Flex Insights
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def assessment_id(self):
        """
        :returns: The Unique Assessment Id.
        :rtype: unicode
        """
        return self._properties['assessment_id']

    @property
    def comment(self):
        """
        :returns: The assessment comment
        :rtype: dict
        """
        return self._properties['comment']

    @property
    def offset(self):
        """
        :returns: Offset.
        :rtype: unicode
        """
        return self._properties['offset']

    @property
    def report(self):
        """
        :returns: Part of assessment report
        :rtype: bool
        """
        return self._properties['report']

    @property
    def weight(self):
        """
        :returns: The weightage
        :rtype: unicode
        """
        return self._properties['weight']

    @property
    def agent_id(self):
        """
        :returns: Agent Id.
        :rtype: unicode
        """
        return self._properties['agent_id']

    @property
    def segment_id(self):
        """
        :returns: Segment Id.
        :rtype: unicode
        """
        return self._properties['segment_id']

    @property
    def user_name(self):
        """
        :returns: The user name.
        :rtype: unicode
        """
        return self._properties['user_name']

    @property
    def user_email(self):
        """
        :returns: The user email id.
        :rtype: unicode
        """
        return self._properties['user_email']

    @property
    def timestamp(self):
        """
        :returns: The timestamp.
        :rtype: unicode
        """
        return self._properties['timestamp']

    @property
    def url(self):
        """
        :returns: The url
        :rtype: unicode
        """
        return self._properties['url']

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.FlexApi.V1.InsightsAssessmentsCommentInstance>'
