# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class LegacyContentList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version):
        """
        Initialize the LegacyContentList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.content.v1.legacy_content.LegacyContentList
        :rtype: twilio.rest.content.v1.legacy_content.LegacyContentList
        """
        super(LegacyContentList, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/LegacyContent'.format(**self._solution)

    def stream(self, limit=None, page_size=None):
        """
        Streams LegacyContentInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.content.v1.legacy_content.LegacyContentInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(page_size=limits['page_size'], )

        return self._version.stream(page, limits['limit'])

    def list(self, limit=None, page_size=None):
        """
        Lists LegacyContentInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.content.v1.legacy_content.LegacyContentInstance]
        """
        return list(self.stream(limit=limit, page_size=page_size, ))

    def page(self, page_token=values.unset, page_number=values.unset,
             page_size=values.unset):
        """
        Retrieve a single page of LegacyContentInstance records from the API.
        Request is executed immediately

        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of LegacyContentInstance
        :rtype: twilio.rest.content.v1.legacy_content.LegacyContentPage
        """
        data = values.of({'PageToken': page_token, 'Page': page_number, 'PageSize': page_size, })

        response = self._version.page(method='GET', uri=self._uri, params=data, )

        return LegacyContentPage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of LegacyContentInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of LegacyContentInstance
        :rtype: twilio.rest.content.v1.legacy_content.LegacyContentPage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return LegacyContentPage(self._version, response, self._solution)

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Content.V1.LegacyContentList>'


class LegacyContentPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the LegacyContentPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.content.v1.legacy_content.LegacyContentPage
        :rtype: twilio.rest.content.v1.legacy_content.LegacyContentPage
        """
        super(LegacyContentPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of LegacyContentInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.content.v1.legacy_content.LegacyContentInstance
        :rtype: twilio.rest.content.v1.legacy_content.LegacyContentInstance
        """
        return LegacyContentInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Content.V1.LegacyContentPage>'


class LegacyContentInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload):
        """
        Initialize the LegacyContentInstance

        :returns: twilio.rest.content.v1.legacy_content.LegacyContentInstance
        :rtype: twilio.rest.content.v1.legacy_content.LegacyContentInstance
        """
        super(LegacyContentInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
            'sid': payload.get('sid'),
            'account_sid': payload.get('account_sid'),
            'friendly_name': payload.get('friendly_name'),
            'language': payload.get('language'),
            'variables': payload.get('variables'),
            'types': payload.get('types'),
            'legacy_template_name': payload.get('legacy_template_name'),
            'legacy_body': payload.get('legacy_body'),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {}

    @property
    def date_created(self):
        """
        :returns: The RFC 2822 date and time in GMT that the resource was created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The RFC 2822 date and time in GMT that the resource was last updated
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def sid(self):
        """
        :returns: The unique string that identifies the resource
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the resource
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def friendly_name(self):
        """
        :returns: A string name used to describe the Content resource
        :rtype: unicode
        """
        return self._properties['friendly_name']

    @property
    def language(self):
        """
        :returns: Two-letter language code identifying the language the Content resource is in.
        :rtype: unicode
        """
        return self._properties['language']

    @property
    def variables(self):
        """
        :returns: Defines the default placeholder values for variables included in the Content resource
        :rtype: dict
        """
        return self._properties['variables']

    @property
    def types(self):
        """
        :returns: The Content types (e.g. twilio/text) for this Content resource
        :rtype: dict
        """
        return self._properties['types']

    @property
    def legacy_template_name(self):
        """
        :returns: The string name of the legacy content template associated with this Content resource
        :rtype: unicode
        """
        return self._properties['legacy_template_name']

    @property
    def legacy_body(self):
        """
        :returns: The string body of this legacy content template
        :rtype: unicode
        """
        return self._properties['legacy_body']

    @property
    def url(self):
        """
        :returns: The URL of the resource, relative to `https://content.twilio.com`
        :rtype: unicode
        """
        return self._properties['url']

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Content.V1.LegacyContentInstance>'
