# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class ContentAndApprovalsList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version):
        """
        Initialize the ContentAndApprovalsList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.content.v1.content_and_approvals.ContentAndApprovalsList
        :rtype: twilio.rest.content.v1.content_and_approvals.ContentAndApprovalsList
        """
        super(ContentAndApprovalsList, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/ContentAndApprovals'.format(**self._solution)

    def stream(self, limit=None, page_size=None):
        """
        Streams ContentAndApprovalsInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.content.v1.content_and_approvals.ContentAndApprovalsInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(page_size=limits['page_size'], )

        return self._version.stream(page, limits['limit'])

    def list(self, limit=None, page_size=None):
        """
        Lists ContentAndApprovalsInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.content.v1.content_and_approvals.ContentAndApprovalsInstance]
        """
        return list(self.stream(limit=limit, page_size=page_size, ))

    def page(self, page_token=values.unset, page_number=values.unset,
             page_size=values.unset):
        """
        Retrieve a single page of ContentAndApprovalsInstance records from the API.
        Request is executed immediately

        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of ContentAndApprovalsInstance
        :rtype: twilio.rest.content.v1.content_and_approvals.ContentAndApprovalsPage
        """
        data = values.of({'PageToken': page_token, 'Page': page_number, 'PageSize': page_size, })

        response = self._version.page(method='GET', uri=self._uri, params=data, )

        return ContentAndApprovalsPage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of ContentAndApprovalsInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of ContentAndApprovalsInstance
        :rtype: twilio.rest.content.v1.content_and_approvals.ContentAndApprovalsPage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return ContentAndApprovalsPage(self._version, response, self._solution)

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Content.V1.ContentAndApprovalsList>'


class ContentAndApprovalsPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the ContentAndApprovalsPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.content.v1.content_and_approvals.ContentAndApprovalsPage
        :rtype: twilio.rest.content.v1.content_and_approvals.ContentAndApprovalsPage
        """
        super(ContentAndApprovalsPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of ContentAndApprovalsInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.content.v1.content_and_approvals.ContentAndApprovalsInstance
        :rtype: twilio.rest.content.v1.content_and_approvals.ContentAndApprovalsInstance
        """
        return ContentAndApprovalsInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Content.V1.ContentAndApprovalsPage>'


class ContentAndApprovalsInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload):
        """
        Initialize the ContentAndApprovalsInstance

        :returns: twilio.rest.content.v1.content_and_approvals.ContentAndApprovalsInstance
        :rtype: twilio.rest.content.v1.content_and_approvals.ContentAndApprovalsInstance
        """
        super(ContentAndApprovalsInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
            'sid': payload.get('sid'),
            'account_sid': payload.get('account_sid'),
            'friendly_name': payload.get('friendly_name'),
            'language': payload.get('language'),
            'variables': payload.get('variables'),
            'types': payload.get('types'),
            'approval_requests': payload.get('approval_requests'),
        }

        # Context
        self._context = None
        self._solution = {}

    @property
    def date_created(self):
        """
        :returns: The RFC 2822 date and time in GMT that the resource was created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The RFC 2822 date and time in GMT that the resource was last updated
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def sid(self):
        """
        :returns: The unique string that identifies the resource
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the resource
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def friendly_name(self):
        """
        :returns: A string name used to describe the Content resource
        :rtype: unicode
        """
        return self._properties['friendly_name']

    @property
    def language(self):
        """
        :returns: Two-letter language code identifying the language the Content resource is in.
        :rtype: unicode
        """
        return self._properties['language']

    @property
    def variables(self):
        """
        :returns: Defines the default placeholder values for variables included in the Content resource
        :rtype: dict
        """
        return self._properties['variables']

    @property
    def types(self):
        """
        :returns: The Content types (e.g. twilio/text) for this Content resource
        :rtype: dict
        """
        return self._properties['types']

    @property
    def approval_requests(self):
        """
        :returns: The approval status of the Content resource.
        :rtype: dict
        """
        return self._properties['approval_requests']

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Content.V1.ContentAndApprovalsInstance>'
