# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.version import Version
from twilio.rest.content.v1.content import ContentList
from twilio.rest.content.v1.content_and_approvals import ContentAndApprovalsList
from twilio.rest.content.v1.legacy_content import LegacyContentList


class V1(Version):

    def __init__(self, domain):
        """
        Initialize the V1 version of Content

        :returns: V1 version of Content
        :rtype: twilio.rest.content.v1.V1.V1
        """
        super(V1, self).__init__(domain)
        self.version = 'v1'
        self._contents = None
        self._content_and_approvals = None
        self._legacy_contents = None

    @property
    def contents(self):
        """
        :rtype: twilio.rest.content.v1.content.ContentList
        """
        if self._contents is None:
            self._contents = ContentList(self)
        return self._contents

    @property
    def content_and_approvals(self):
        """
        :rtype: twilio.rest.content.v1.content_and_approvals.ContentAndApprovalsList
        """
        if self._content_and_approvals is None:
            self._content_and_approvals = ContentAndApprovalsList(self)
        return self._content_and_approvals

    @property
    def legacy_contents(self):
        """
        :rtype: twilio.rest.content.v1.legacy_content.LegacyContentList
        """
        if self._legacy_contents is None:
            self._legacy_contents = LegacyContentList(self)
        return self._legacy_contents

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Content.V1>'
