# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class UserDefinedMessageList(ListResource):

    def __init__(self, version, account_sid, call_sid):
        """
        Initialize the UserDefinedMessageList

        :param Version version: Version that contains the resource
        :param account_sid: Account SID.
        :param call_sid: Call SID.

        :returns: twilio.rest.api.v2010.account.call.user_defined_message.UserDefinedMessageList
        :rtype: twilio.rest.api.v2010.account.call.user_defined_message.UserDefinedMessageList
        """
        super(UserDefinedMessageList, self).__init__(version)

        # Path Solution
        self._solution = {'account_sid': account_sid, 'call_sid': call_sid, }
        self._uri = '/Accounts/{account_sid}/Calls/{call_sid}/UserDefinedMessages.json'.format(**self._solution)

    def create(self, content, idempotency_key=values.unset):
        """
        Create the UserDefinedMessageInstance

        :param unicode content: The User Defined Message in the form of URL-encoded JSON string.
        :param unicode idempotency_key: A unique string value to identify API call. This should be a unique string value per API call and can be a randomly generated.

        :returns: The created UserDefinedMessageInstance
        :rtype: twilio.rest.api.v2010.account.call.user_defined_message.UserDefinedMessageInstance
        """
        data = values.of({'Content': content, 'IdempotencyKey': idempotency_key, })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return UserDefinedMessageInstance(
            self._version,
            payload,
            account_sid=self._solution['account_sid'],
            call_sid=self._solution['call_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Api.V2010.UserDefinedMessageList>'


class UserDefinedMessagePage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the UserDefinedMessagePage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param account_sid: Account SID.
        :param call_sid: Call SID.

        :returns: twilio.rest.api.v2010.account.call.user_defined_message.UserDefinedMessagePage
        :rtype: twilio.rest.api.v2010.account.call.user_defined_message.UserDefinedMessagePage
        """
        super(UserDefinedMessagePage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of UserDefinedMessageInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.api.v2010.account.call.user_defined_message.UserDefinedMessageInstance
        :rtype: twilio.rest.api.v2010.account.call.user_defined_message.UserDefinedMessageInstance
        """
        return UserDefinedMessageInstance(
            self._version,
            payload,
            account_sid=self._solution['account_sid'],
            call_sid=self._solution['call_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Api.V2010.UserDefinedMessagePage>'


class UserDefinedMessageInstance(InstanceResource):

    def __init__(self, version, payload, account_sid, call_sid):
        """
        Initialize the UserDefinedMessageInstance

        :returns: twilio.rest.api.v2010.account.call.user_defined_message.UserDefinedMessageInstance
        :rtype: twilio.rest.api.v2010.account.call.user_defined_message.UserDefinedMessageInstance
        """
        super(UserDefinedMessageInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'call_sid': payload.get('call_sid'),
            'sid': payload.get('sid'),
            'date_created': deserialize.rfc2822_datetime(payload.get('date_created')),
        }

        # Context
        self._context = None
        self._solution = {'account_sid': account_sid, 'call_sid': call_sid, }

    @property
    def account_sid(self):
        """
        :returns: Account SID.
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def call_sid(self):
        """
        :returns: Call SID.
        :rtype: unicode
        """
        return self._properties['call_sid']

    @property
    def sid(self):
        """
        :returns: User Defined Message SID.
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def date_created(self):
        """
        :returns: The date this User Defined Message was created.
        :rtype: datetime
        """
        return self._properties['date_created']

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Api.V2010.UserDefinedMessageInstance>'
