"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KafkaVersion = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Kafka cluster version
 */
class KafkaVersion {
    /**
     *
     * @param version cluster version number
     */
    constructor(version) {
        this.version = version;
    }
    /**
     * Custom cluster version
     * @param version custom version number
     */
    static of(version) {
        return new KafkaVersion(version);
    }
}
exports.KafkaVersion = KafkaVersion;
_a = JSII_RTTI_SYMBOL_1;
KafkaVersion[_a] = { fqn: "@aws-cdk/aws-msk-alpha.KafkaVersion", version: "2.62.1-alpha.0" };
/**
 * Kafka version 1.1.1
 */
KafkaVersion.V1_1_1 = KafkaVersion.of('1.1.1');
/**
 * Kafka version 2.2.1
 */
KafkaVersion.V2_2_1 = KafkaVersion.of('2.2.1');
/**
 * Kafka version 2.3.1
 */
KafkaVersion.V2_3_1 = KafkaVersion.of('2.3.1');
/**
 * Kafka version 2.4.1
 */
KafkaVersion.V2_4_1_1 = KafkaVersion.of('2.4.1.1');
/**
 * Kafka version 2.5.1
 */
KafkaVersion.V2_5_1 = KafkaVersion.of('2.5.1');
/**
 * Kafka version 2.6.0
 */
KafkaVersion.V2_6_0 = KafkaVersion.of('2.6.0');
/**
 * Kafka version 2.6.1
 */
KafkaVersion.V2_6_1 = KafkaVersion.of('2.6.1');
/**
 * Kafka version 2.6.2
 */
KafkaVersion.V2_6_2 = KafkaVersion.of('2.6.2');
/**
 * Kafka version 2.6.3
 */
KafkaVersion.V2_6_3 = KafkaVersion.of('2.6.3');
/**
 * Kafka version 2.7.0
 */
KafkaVersion.V2_7_0 = KafkaVersion.of('2.7.0');
/**
 * Kafka version 2.7.1
 */
KafkaVersion.V2_7_1 = KafkaVersion.of('2.7.1');
/**
 * Kafka version 2.7.2
 */
KafkaVersion.V2_7_2 = KafkaVersion.of('2.7.2');
/**
 * Kafka version 2.8.0
 */
KafkaVersion.V2_8_0 = KafkaVersion.of('2.8.0');
/**
 * Kafka version 2.8.1
 */
KafkaVersion.V2_8_1 = KafkaVersion.of('2.8.1');
//# sourceMappingURL=data:application/json;base64,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