# mypy-boto3-elasticache

[![PyPI - mypy-boto3-elasticache](https://img.shields.io/pypi/v/mypy-boto3-elasticache.svg?color=blue)](https://pypi.org/project/mypy-boto3-elasticache)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-elasticache.svg?color=blue)](https://pypi.org/project/mypy-boto3-elasticache)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.ElastiCache 1.16.18](https://boto3.amazonaws.com/v1/documentation/api/1.16.18/reference/services/elasticache.html#ElastiCache) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.2.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-elasticache](#mypy-boto3-elasticache)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `ElastiCache` service.

```bash
python -m pip install boto3-stubs[elasticache]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[elasticache]` in your environment: `python -m pip install 'boto3-stubs[elasticache]'`

Both type checking and auto-complete should work for `ElastiCache` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[elasticache]` in your environment: `python -m pip install 'boto3-stubs[elasticache]'`

Both type checking and auto-complete should work for `ElastiCache` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[elasticache]` in your environment: `python -m pip install 'boto3-stubs[elasticache]'`
- Run `mypy` as usual

Type checking should work for `ElastiCache` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[elasticache]` in your environment: `python -m pip install 'boto3-stubs[elasticache]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `ElastiCache` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`ElastiCacheClient` provides annotations for `boto3.client("elasticache")`.

```python
import boto3

from mypy_boto3_elasticache import ElastiCacheClient

client: ElastiCacheClient = boto3.client("elasticache")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ElastiCacheClient = session.client("elasticache")
```

### Paginators annotations

`mypy_boto3_elasticache.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_elasticache import ElastiCacheClient
from mypy_boto3_elasticache.paginator import (
    DescribeCacheClustersPaginator,
    DescribeCacheEngineVersionsPaginator,
    DescribeCacheParameterGroupsPaginator,
    DescribeCacheParametersPaginator,
    DescribeCacheSecurityGroupsPaginator,
    DescribeCacheSubnetGroupsPaginator,
    DescribeEngineDefaultParametersPaginator,
    DescribeEventsPaginator,
    DescribeGlobalReplicationGroupsPaginator,
    DescribeReplicationGroupsPaginator,
    DescribeReservedCacheNodesOfferingsPaginator,
    DescribeReservedCacheNodesPaginator,
    DescribeServiceUpdatesPaginator,
    DescribeSnapshotsPaginator,
    DescribeUpdateActionsPaginator,
    DescribeUserGroupsPaginator,
    DescribeUsersPaginator,
)

client: ElastiCacheClient = boto3.client("elasticache")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_cache_clusters_paginator: DescribeCacheClustersPaginator = client.get_paginator("describe_cache_clusters")
describe_cache_engine_versions_paginator: DescribeCacheEngineVersionsPaginator = client.get_paginator("describe_cache_engine_versions")
describe_cache_parameter_groups_paginator: DescribeCacheParameterGroupsPaginator = client.get_paginator("describe_cache_parameter_groups")
describe_cache_parameters_paginator: DescribeCacheParametersPaginator = client.get_paginator("describe_cache_parameters")
describe_cache_security_groups_paginator: DescribeCacheSecurityGroupsPaginator = client.get_paginator("describe_cache_security_groups")
describe_cache_subnet_groups_paginator: DescribeCacheSubnetGroupsPaginator = client.get_paginator("describe_cache_subnet_groups")
describe_engine_default_parameters_paginator: DescribeEngineDefaultParametersPaginator = client.get_paginator("describe_engine_default_parameters")
describe_events_paginator: DescribeEventsPaginator = client.get_paginator("describe_events")
describe_global_replication_groups_paginator: DescribeGlobalReplicationGroupsPaginator = client.get_paginator("describe_global_replication_groups")
describe_replication_groups_paginator: DescribeReplicationGroupsPaginator = client.get_paginator("describe_replication_groups")
describe_reserved_cache_nodes_paginator: DescribeReservedCacheNodesPaginator = client.get_paginator("describe_reserved_cache_nodes")
describe_reserved_cache_nodes_offerings_paginator: DescribeReservedCacheNodesOfferingsPaginator = client.get_paginator("describe_reserved_cache_nodes_offerings")
describe_service_updates_paginator: DescribeServiceUpdatesPaginator = client.get_paginator("describe_service_updates")
describe_snapshots_paginator: DescribeSnapshotsPaginator = client.get_paginator("describe_snapshots")
describe_update_actions_paginator: DescribeUpdateActionsPaginator = client.get_paginator("describe_update_actions")
describe_user_groups_paginator: DescribeUserGroupsPaginator = client.get_paginator("describe_user_groups")
describe_users_paginator: DescribeUsersPaginator = client.get_paginator("describe_users")
```


### Waiters annotations

`mypy_boto3_elasticache.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_elasticache import ElastiCacheClient
from mypy_boto3_elasticache.waiter import (
    CacheClusterAvailableWaiter,
    CacheClusterDeletedWaiter,
    ReplicationGroupAvailableWaiter,
    ReplicationGroupDeletedWaiter,
)

client: ElastiCacheClient = boto3.client("elasticache")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
cache_cluster_available_waiter: CacheClusterAvailableWaiter = client.get_waiter("cache_cluster_available")
cache_cluster_deleted_waiter: CacheClusterDeletedWaiter = client.get_waiter("cache_cluster_deleted")
replication_group_available_waiter: ReplicationGroupAvailableWaiter = client.get_waiter("replication_group_available")
replication_group_deleted_waiter: ReplicationGroupDeletedWaiter = client.get_waiter("replication_group_deleted")
```





### Typed dictionations

`mypy_boto3_elasticache.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_elasticache.type_defs import (
    AllowedNodeTypeModificationsMessageTypeDef,
    AuthenticationTypeDef,
    AuthorizeCacheSecurityGroupIngressResultTypeDef,
    AvailabilityZoneTypeDef,
    CacheClusterMessageTypeDef,
    CacheClusterTypeDef,
    CacheEngineVersionMessageTypeDef,
    CacheEngineVersionTypeDef,
    CacheNodeTypeDef,
    CacheNodeTypeSpecificParameterTypeDef,
    CacheNodeTypeSpecificValueTypeDef,
    CacheNodeUpdateStatusTypeDef,
    CacheParameterGroupDetailsTypeDef,
    CacheParameterGroupNameMessageTypeDef,
    CacheParameterGroupsMessageTypeDef,
    CacheParameterGroupStatusTypeDef,
    CacheParameterGroupTypeDef,
    CacheSecurityGroupMembershipTypeDef,
    CacheSecurityGroupMessageTypeDef,
    CacheSecurityGroupTypeDef,
    CacheSubnetGroupMessageTypeDef,
    CacheSubnetGroupTypeDef,
    CompleteMigrationResponseTypeDef,
    ConfigureShardTypeDef,
    CopySnapshotResultTypeDef,
    CreateCacheClusterResultTypeDef,
    CreateCacheParameterGroupResultTypeDef,
    CreateCacheSecurityGroupResultTypeDef,
    CreateCacheSubnetGroupResultTypeDef,
    CreateGlobalReplicationGroupResultTypeDef,
    CreateReplicationGroupResultTypeDef,
    CreateSnapshotResultTypeDef,
    CustomerNodeEndpointTypeDef,
    DecreaseNodeGroupsInGlobalReplicationGroupResultTypeDef,
    DecreaseReplicaCountResultTypeDef,
    DeleteCacheClusterResultTypeDef,
    DeleteGlobalReplicationGroupResultTypeDef,
    DeleteReplicationGroupResultTypeDef,
    DeleteSnapshotResultTypeDef,
    DescribeEngineDefaultParametersResultTypeDef,
    DescribeGlobalReplicationGroupsResultTypeDef,
    DescribeSnapshotsListMessageTypeDef,
    DescribeUserGroupsResultTypeDef,
    DescribeUsersResultTypeDef,
    DisassociateGlobalReplicationGroupResultTypeDef,
    EC2SecurityGroupTypeDef,
    EndpointTypeDef,
    EngineDefaultsTypeDef,
    EventsMessageTypeDef,
    EventTypeDef,
    FailoverGlobalReplicationGroupResultTypeDef,
    FilterTypeDef,
    GlobalNodeGroupTypeDef,
    GlobalReplicationGroupInfoTypeDef,
    GlobalReplicationGroupMemberTypeDef,
    GlobalReplicationGroupTypeDef,
    IncreaseNodeGroupsInGlobalReplicationGroupResultTypeDef,
    IncreaseReplicaCountResultTypeDef,
    ModifyCacheClusterResultTypeDef,
    ModifyCacheSubnetGroupResultTypeDef,
    ModifyGlobalReplicationGroupResultTypeDef,
    ModifyReplicationGroupResultTypeDef,
    ModifyReplicationGroupShardConfigurationResultTypeDef,
    NodeGroupConfigurationTypeDef,
    NodeGroupMemberTypeDef,
    NodeGroupMemberUpdateStatusTypeDef,
    NodeGroupTypeDef,
    NodeGroupUpdateStatusTypeDef,
    NodeSnapshotTypeDef,
    NotificationConfigurationTypeDef,
    PaginatorConfigTypeDef,
    ParameterNameValueTypeDef,
    ParameterTypeDef,
    PendingModifiedValuesTypeDef,
    ProcessedUpdateActionTypeDef,
    PurchaseReservedCacheNodesOfferingResultTypeDef,
    RebalanceSlotsInGlobalReplicationGroupResultTypeDef,
    RebootCacheClusterResultTypeDef,
    RecurringChargeTypeDef,
    RegionalConfigurationTypeDef,
    ReplicationGroupMessageTypeDef,
    ReplicationGroupPendingModifiedValuesTypeDef,
    ReplicationGroupTypeDef,
    ReservedCacheNodeMessageTypeDef,
    ReservedCacheNodesOfferingMessageTypeDef,
    ReservedCacheNodesOfferingTypeDef,
    ReservedCacheNodeTypeDef,
    ReshardingConfigurationTypeDef,
    ReshardingStatusTypeDef,
    RevokeCacheSecurityGroupIngressResultTypeDef,
    SecurityGroupMembershipTypeDef,
    ServiceUpdatesMessageTypeDef,
    ServiceUpdateTypeDef,
    SlotMigrationTypeDef,
    SnapshotTypeDef,
    StartMigrationResponseTypeDef,
    SubnetOutpostTypeDef,
    SubnetTypeDef,
    TagListMessageTypeDef,
    TagTypeDef,
    TestFailoverResultTypeDef,
    TimeRangeFilterTypeDef,
    UnprocessedUpdateActionTypeDef,
    UpdateActionResultsMessageTypeDef,
    UpdateActionsMessageTypeDef,
    UpdateActionTypeDef,
    UserGroupPendingChangesTypeDef,
    UserGroupsUpdateStatusTypeDef,
    UserGroupTypeDef,
    UserTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AuthenticationTypeDef:
    return {
      ...
    }
```
