import { IConstruct, Stack } from 'monocdk';
/**
 * Interface for creating a rule suppression.
 *
 * @stability stable
 */
export interface NagPackSuppression {
    /**
     * The id of the rule to ignore.
     *
     * @stability stable
     */
    readonly id: string;
    /**
     * The reason to ignore the rule (minimum 10 characters).
     *
     * @stability stable
     */
    readonly reason: string;
}
/**
 * Helper class with methods to add cdk-nag suppressions to cdk resources.
 *
 * @stability stable
 */
export declare class NagSuppressions {
    /**
     * Add cdk-nag suppressions to the Stack.
     *
     * @param stack the Stack to apply the suppression to.
     * @param suppressions a list of suppressions to apply to the stack.
     * @stability stable
     */
    static addStackSuppressions(stack: Stack, suppressions: NagPackSuppression[]): void;
    /**
     * Add cdk-nag suppressions to the construct if it is a CfnResource.
     *
     * @param construct the IConstruct to apply the suppression to.
     * @param suppressions a list of suppressions to apply to the resource.
     * @param applyToChildren apply the suppressions to this construct and all of its children if they exist (default:false).
     * @stability stable
     */
    static addResourceSuppressions(construct: IConstruct, suppressions: NagPackSuppression[], applyToChildren?: boolean): void;
    /**
     * Locate a construct by it's path and add cdk-nag suppressions if it both exists and is a CfnResource.
     *
     * @param stack the Stack the construct belongs to.
     * @param path the path of the construct in the provided stack.
     * @param suppressions a list of suppressions to apply to the resource.
     * @param applyToChildren apply the suppressions to this construct and all of its children if they exist (default:false).
     * @stability stable
     */
    static addResourceSuppressionsByPath(stack: Stack, path: string, suppressions: NagPackSuppression[], applyToChildren?: boolean): void;
}
