"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_s3_1 = require("monocdk/aws-s3");
/**
 * S3 Buckets have server access logs enabled - (Control IDs: 2.2, 10.1, 10.2.1, 10.2.2, 10.2.3, 10.2.4, 10.2.5, 10.2.7, 10.3.1, 10.3.2, 10.3.3, 10.3.4, 10.3.5, 10.3.6)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_s3_1.CfnBucket) {
        const logging = monocdk_1.Stack.of(node).resolve(node.loggingConfiguration);
        if (logging == undefined ||
            (logging.destinationBucketName == undefined &&
                logging.logFilePrefix == undefined)) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGNpRHNzMzIxUzNCdWNrZXRMb2dnaW5nRW5hYmxlZC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9QQ0ktRFNTLTMuMi4xL3J1bGVzL3MzL3BjaURzczMyMVMzQnVja2V0TG9nZ2luZ0VuYWJsZWQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQTs7O0VBR0U7QUFDRixxQ0FBNkM7QUFDN0MsMkNBQTJDO0FBRTNDOzs7R0FHRztBQUNILG1CQUF5QixJQUFpQjtJQUN4QyxJQUFJLElBQUksWUFBWSxrQkFBUyxFQUFFO1FBQzdCLE1BQU0sT0FBTyxHQUFHLGVBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO1FBQ2xFLElBQ0UsT0FBTyxJQUFJLFNBQVM7WUFDcEIsQ0FBQyxPQUFPLENBQUMscUJBQXFCLElBQUksU0FBUztnQkFDekMsT0FBTyxDQUFDLGFBQWEsSUFBSSxTQUFTLENBQUMsRUFDckM7WUFDQSxPQUFPLEtBQUssQ0FBQztTQUNkO0tBQ0Y7SUFDRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUFaRCw0QkFZQyIsInNvdXJjZXNDb250ZW50IjpbIi8qXG5Db3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4qL1xuaW1wb3J0IHsgQ2ZuUmVzb3VyY2UsIFN0YWNrIH0gZnJvbSAnbW9ub2Nkayc7XG5pbXBvcnQgeyBDZm5CdWNrZXQgfSBmcm9tICdtb25vY2RrL2F3cy1zMyc7XG5cbi8qKlxuICogUzMgQnVja2V0cyBoYXZlIHNlcnZlciBhY2Nlc3MgbG9ncyBlbmFibGVkIC0gKENvbnRyb2wgSURzOiAyLjIsIDEwLjEsIDEwLjIuMSwgMTAuMi4yLCAxMC4yLjMsIDEwLjIuNCwgMTAuMi41LCAxMC4yLjcsIDEwLjMuMSwgMTAuMy4yLCAxMC4zLjMsIDEwLjMuNCwgMTAuMy41LCAxMC4zLjYpXG4gKiBAcGFyYW0gbm9kZSB0aGUgQ2ZuUmVzb3VyY2UgdG8gY2hlY2tcbiAqL1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gKG5vZGU6IENmblJlc291cmNlKTogYm9vbGVhbiB7XG4gIGlmIChub2RlIGluc3RhbmNlb2YgQ2ZuQnVja2V0KSB7XG4gICAgY29uc3QgbG9nZ2luZyA9IFN0YWNrLm9mKG5vZGUpLnJlc29sdmUobm9kZS5sb2dnaW5nQ29uZmlndXJhdGlvbik7XG4gICAgaWYgKFxuICAgICAgbG9nZ2luZyA9PSB1bmRlZmluZWQgfHxcbiAgICAgIChsb2dnaW5nLmRlc3RpbmF0aW9uQnVja2V0TmFtZSA9PSB1bmRlZmluZWQgJiZcbiAgICAgICAgbG9nZ2luZy5sb2dGaWxlUHJlZml4ID09IHVuZGVmaW5lZClcbiAgICApIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG4gIH1cbiAgcmV0dXJuIHRydWU7XG59XG4iXX0=