"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_redshift_1 = require("monocdk/aws-redshift");
const nag_pack_1 = require("../../../nag-pack");
/**
 * Redshift clusters have version upgrades enabled, automated snapshot retention periods enabled, and explicit maintenance windows configured - (Control ID: 6.2)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_redshift_1.CfnCluster) {
        const allowVersionUpgrade = nag_pack_1.resolveIfPrimitive(node, node.allowVersionUpgrade);
        const automatedSnapshotRetentionPeriod = nag_pack_1.resolveIfPrimitive(node, node.automatedSnapshotRetentionPeriod);
        if ((automatedSnapshotRetentionPeriod != undefined &&
            automatedSnapshotRetentionPeriod == 0) ||
            node.preferredMaintenanceWindow == undefined ||
            allowVersionUpgrade === false) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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