"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_rds_1 = require("monocdk/aws-rds");
const nag_pack_1 = require("../../../nag-pack");
/**
 * RDS DB instances are configured to export all possible log types to CloudWatch - (Control IDs: 10.1, 10.2.1, 10.2.2, 10.2.3, 10.2.4, 10.2.5, 10.3.1, 10.3.2, 10.3.3, 10.3.4, 10.3.5, 10.3.6)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_rds_1.CfnDBInstance) {
        const dbType = JSON.stringify(nag_pack_1.resolveIfPrimitive(node, node.engine));
        const dbLogs = JSON.stringify(monocdk_1.Stack.of(node).resolve(node.enableCloudwatchLogsExports));
        if (dbLogs == undefined) {
            return false;
        }
        if (dbType.includes('mariadb') || dbType.includes('mysql')) {
            if (!(dbLogs.includes('audit') &&
                dbLogs.includes('error') &&
                dbLogs.includes('general') &&
                dbLogs.includes('slowquery'))) {
                return false;
            }
        }
        if (dbType.includes('postgres')) {
            if (!(dbLogs.includes('postgresql') && dbLogs.includes('upgrade'))) {
                return false;
            }
        }
        if (dbType.includes('oracle')) {
            if (!(dbLogs.includes('audit') &&
                dbLogs.includes('alert') &&
                dbLogs.includes('listener') &&
                dbLogs.includes('oemagent') &&
                dbLogs.includes('trace'))) {
                return false;
            }
        }
        if (dbType.includes('sqlserver')) {
            if (!(dbLogs.includes('agent') && dbLogs.includes('error')))
                return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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