"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const monocdk_1 = require("monocdk");
const aws_ec2_1 = require("monocdk/aws-ec2");
const nag_pack_1 = require("../../../nag-pack");
/**
 * Security Groups do not allow for unrestricted SSH traffic - (Control IDs: 1.2, 1.2.1, 1.3, 1.3.1, 1.3.2, 2.2, 2.2.2)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_ec2_1.CfnSecurityGroup) {
        const ingressRules = monocdk_1.Stack.of(node).resolve(node.securityGroupIngress);
        if (ingressRules != undefined) {
            //For each ingress rule, ensure that it does not allow unrestricted SSH traffic.
            for (const rule of ingressRules) {
                const resolvedRule = monocdk_1.Stack.of(node).resolve(rule);
                const ipProtocol = nag_pack_1.resolveIfPrimitive(node, resolvedRule.ipProtocol);
                const cidrIp = nag_pack_1.resolveIfPrimitive(node, resolvedRule.cidrIp);
                const cidrIpv6 = nag_pack_1.resolveIfPrimitive(node, resolvedRule.cidrIpv6);
                const fromPort = nag_pack_1.resolveIfPrimitive(node, resolvedRule.fromPort);
                const toPort = nag_pack_1.resolveIfPrimitive(node, resolvedRule.toPort);
                if ((cidrIp != undefined && cidrIp.includes('/0')) ||
                    (cidrIpv6 != undefined && cidrIpv6.includes('/0'))) {
                    if (fromPort != undefined && toPort != undefined) {
                        if ((fromPort <= 22 && toPort >= 22) ||
                            fromPort == -1 ||
                            toPort == -1 ||
                            ipProtocol == '-1') {
                            return false;
                        }
                    }
                    else {
                        if (fromPort == 22 || ipProtocol == '-1') {
                            return false;
                        }
                    }
                }
            }
        }
    }
    else if (node instanceof aws_ec2_1.CfnSecurityGroupIngress) {
        const ipProtocol = nag_pack_1.resolveIfPrimitive(node, node.ipProtocol);
        const cidrIp = nag_pack_1.resolveIfPrimitive(node, node.cidrIp);
        const cidrIpv6 = nag_pack_1.resolveIfPrimitive(node, node.cidrIpv6);
        const fromPort = nag_pack_1.resolveIfPrimitive(node, node.fromPort);
        const toPort = nag_pack_1.resolveIfPrimitive(node, node.toPort);
        if ((cidrIp != undefined && cidrIp.includes('/0')) ||
            (cidrIpv6 != undefined && cidrIpv6.includes('/0'))) {
            //Is a port range specified?
            if (fromPort != undefined && toPort != undefined) {
                if ((fromPort <= 22 && toPort >= 22) ||
                    fromPort == -1 ||
                    toPort == -1 ||
                    ipProtocol == '-1') {
                    return false;
                }
            }
            else {
                if (fromPort == 22 || ipProtocol == '-1') {
                    return false;
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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