"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_iam_1 = require("monocdk/aws-iam");
/**
 * IAM policies do not grant full access - (Control IDs: AC-3, AC-5b, AC-6(2), AC-6(10), CM-5(1)(a))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_iam_1.CfnPolicy || node instanceof aws_iam_1.CfnManagedPolicy) {
        if (checkDocument(node, node.policyDocument)) {
            return false;
        }
    }
    else if (node instanceof aws_iam_1.CfnGroup || node instanceof aws_iam_1.CfnRole) {
        if (node.policies != undefined && checkDocument(node, node.policies)) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
/**
 * Helper function for parsing through the policy document
 * @param node the CfnResource to Check
 * @param policyDoc the JSON policy document
 * @returns boolean
 */
function checkDocument(node, policyDoc) {
    const resolvedDoc = monocdk_1.Stack.of(node).resolve(policyDoc);
    const reg = /"Action":\[?(.*,)?"(?:\w+:)?\*"(,.*)?\]?,"Effect":"Allow"/gm;
    if (JSON.stringify(resolvedDoc).search(reg) != -1) {
        return true;
    }
    return false;
}
//# sourceMappingURL=data:application/json;base64,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