"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const monocdk_1 = require("monocdk");
const aws_elasticloadbalancing_1 = require("monocdk/aws-elasticloadbalancing");
const nag_pack_1 = require("../../../nag-pack");
/**
 * CLBs use ACM-managed certificates - (Control IDs: AC-4, AC-4(22), AC-17(2), AC-24(1), AU-9(3), CA-9b, IA-5(1)(c), PM-17b, SC-7(4)(b), SC-7(4)(g), SC-8, SC-8(1), SC-8(2), SC-8(3), SC-8(4), SC-8(5), SC-13a, SC-23, SC-23(5), SI-1a.2, SI-1a.2, SI-1c.2)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_elasticloadbalancing_1.CfnLoadBalancer) {
        //For each listener, ensure that it's utilizing an ACM SSL/HTTPS cert
        const listeners = monocdk_1.Stack.of(node).resolve(node.listeners);
        if (listeners != undefined) {
            //Iterate through listeners, checking if secured ACM certs are used
            for (const listener of listeners) {
                const resolvedListener = monocdk_1.Stack.of(node).resolve(listener);
                const listenerARN = nag_pack_1.resolveIfPrimitive(node, resolvedListener.sslCertificateId);
                //Use the ARN to check if this is an ACM managed cert
                if (listenerARN == undefined) {
                    return false;
                }
                else {
                    const acmRegex = /^arn:[^:]+:acm:.+$/;
                    if (!acmRegex.test(listenerARN)) {
                        return false;
                    }
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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