"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_s3_1 = require("monocdk/aws-s3");
const nag_pack_1 = require("../../../nag-pack");
/**
 * S3 Buckets have versioningConfiguration enabled - (Control IDs: CP-10, SI-12)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_s3_1.CfnBucket) {
        const versioningConfiguration = monocdk_1.Stack.of(node).resolve(node.versioningConfiguration);
        if (versioningConfiguration === undefined ||
            nag_pack_1.resolveIfPrimitive(node, versioningConfiguration.status) === 'Suspended') {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmlzdDgwMDUzcjRTM0J1Y2tldFZlcnNpb25pbmdFbmFibGVkLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL05JU1QtODAwLTUzLVI0L3J1bGVzL3MzL25pc3Q4MDA1M3I0UzNCdWNrZXRWZXJzaW9uaW5nRW5hYmxlZC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBOzs7RUFHRTtBQUNGLHFDQUE2QztBQUM3QywyQ0FBMkM7QUFDM0MsZ0RBQXVEO0FBRXZEOzs7R0FHRztBQUNILG1CQUF5QixJQUFpQjtJQUN4QyxJQUFJLElBQUksWUFBWSxrQkFBUyxFQUFFO1FBQzdCLE1BQU0sdUJBQXVCLEdBQUcsZUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQ3BELElBQUksQ0FBQyx1QkFBdUIsQ0FDN0IsQ0FBQztRQUNGLElBQ0UsdUJBQXVCLEtBQUssU0FBUztZQUNyQyw2QkFBa0IsQ0FBQyxJQUFJLEVBQUUsdUJBQXVCLENBQUMsTUFBTSxDQUFDLEtBQUssV0FBVyxFQUN4RTtZQUNBLE9BQU8sS0FBSyxDQUFDO1NBQ2Q7S0FDRjtJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQWJELDRCQWFDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5pbXBvcnQgeyBDZm5SZXNvdXJjZSwgU3RhY2sgfSBmcm9tICdtb25vY2RrJztcbmltcG9ydCB7IENmbkJ1Y2tldCB9IGZyb20gJ21vbm9jZGsvYXdzLXMzJztcbmltcG9ydCB7IHJlc29sdmVJZlByaW1pdGl2ZSB9IGZyb20gJy4uLy4uLy4uL25hZy1wYWNrJztcblxuLyoqXG4gKiBTMyBCdWNrZXRzIGhhdmUgdmVyc2lvbmluZ0NvbmZpZ3VyYXRpb24gZW5hYmxlZCAtIChDb250cm9sIElEczogQ1AtMTAsIFNJLTEyKVxuICogQHBhcmFtIG5vZGUgdGhlIENmblJlc291cmNlIHRvIGNoZWNrXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIChub2RlOiBDZm5SZXNvdXJjZSk6IGJvb2xlYW4ge1xuICBpZiAobm9kZSBpbnN0YW5jZW9mIENmbkJ1Y2tldCkge1xuICAgIGNvbnN0IHZlcnNpb25pbmdDb25maWd1cmF0aW9uID0gU3RhY2sub2Yobm9kZSkucmVzb2x2ZShcbiAgICAgIG5vZGUudmVyc2lvbmluZ0NvbmZpZ3VyYXRpb24sXG4gICAgKTtcbiAgICBpZiAoXG4gICAgICB2ZXJzaW9uaW5nQ29uZmlndXJhdGlvbiA9PT0gdW5kZWZpbmVkIHx8XG4gICAgICByZXNvbHZlSWZQcmltaXRpdmUobm9kZSwgdmVyc2lvbmluZ0NvbmZpZ3VyYXRpb24uc3RhdHVzKSA9PT0gJ1N1c3BlbmRlZCdcbiAgICApIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG4gIH1cbiAgcmV0dXJuIHRydWU7XG59XG4iXX0=