"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_s3_1 = require("monocdk/aws-s3");
const nag_pack_1 = require("../../../nag-pack");
/**
 * S3 Buckets have object lock enabled - (Control ID: SC-28)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_s3_1.CfnBucket) {
        const objectLockEnabled = nag_pack_1.resolveIfPrimitive(node, node.objectLockEnabled);
        const objectLockConfiguration = monocdk_1.Stack.of(node).resolve(node.objectLockConfiguration);
        if (objectLockEnabled !== true ||
            objectLockConfiguration === undefined ||
            nag_pack_1.resolveIfPrimitive(node, objectLockConfiguration.objectLockEnabled) !==
                'Enabled') {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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