"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_rds_1 = require("monocdk/aws-rds");
const nag_pack_1 = require("../../../nag-pack");
/**
 * RDS DB instances are configured to export all possible log types to CloudWatch - (Control IDs: AC-2(4), AC-2(g), AU-2(a)(d), AU-3, AU-12(a)(c))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_rds_1.CfnDBInstance) {
        const dbType = JSON.stringify(nag_pack_1.resolveIfPrimitive(node, node.engine));
        const dbLogs = JSON.stringify(monocdk_1.Stack.of(node).resolve(node.enableCloudwatchLogsExports));
        if (dbLogs == undefined) {
            return false;
        }
        if (dbType.includes('mariadb') || dbType.includes('mysql')) {
            if (!(dbLogs.includes('audit') &&
                dbLogs.includes('error') &&
                dbLogs.includes('general') &&
                dbLogs.includes('slowquery'))) {
                return false;
            }
        }
        if (dbType.includes('postgres')) {
            if (!(dbLogs.includes('postgresql') && dbLogs.includes('upgrade'))) {
                return false;
            }
        }
        if (dbType.includes('oracle')) {
            if (!(dbLogs.includes('audit') &&
                dbLogs.includes('alert') &&
                dbLogs.includes('listener') &&
                dbLogs.includes('oemagent') &&
                dbLogs.includes('trace'))) {
                return false;
            }
        }
        if (dbType.includes('sqlserver')) {
            if (!(dbLogs.includes('agent') && dbLogs.includes('error')))
                return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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