"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_elasticache_1 = require("monocdk/aws-elasticache");
const nag_pack_1 = require("../../../nag-pack");
/**
 * ElastiCache Redis clusters retain automatic backups for at least 15 days - (Control IDs: CP-9(b), CP-10, SI-12)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_elasticache_1.CfnCacheCluster) {
        const engine = nag_pack_1.resolveIfPrimitive(node, node.engine.toLowerCase());
        const retention = nag_pack_1.resolveIfPrimitive(node, node.snapshotRetentionLimit);
        if (engine == 'redis' && (retention == undefined || retention < 15)) {
            return false;
        }
    }
    else if (node instanceof aws_elasticache_1.CfnReplicationGroup) {
        const retention = nag_pack_1.resolveIfPrimitive(node, node.snapshotRetentionLimit);
        if (retention == undefined || retention < 15) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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