"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_cloudtrail_1 = require("monocdk/aws-cloudtrail");
const nag_pack_1 = require("../../../nag-pack");
/**
 * CloudTrail trails have log file validation enabled - (Control ID: AC-6)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_cloudtrail_1.CfnTrail) {
        const enabled = nag_pack_1.resolveIfPrimitive(node, node.enableLogFileValidation);
        if (enabled != true) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmlzdDgwMDUzcjRDbG91ZFRyYWlsTG9nRmlsZVZhbGlkYXRpb25FbmFibGVkLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL05JU1QtODAwLTUzLVI0L3J1bGVzL2Nsb3VkdHJhaWwvbmlzdDgwMDUzcjRDbG91ZFRyYWlsTG9nRmlsZVZhbGlkYXRpb25FbmFibGVkLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBS0EsMkRBQWtEO0FBQ2xELGdEQUF1RDtBQUN2RDs7O0dBR0c7QUFDSCxtQkFBeUIsSUFBaUI7SUFDeEMsSUFBSSxJQUFJLFlBQVkseUJBQVEsRUFBRTtRQUM1QixNQUFNLE9BQU8sR0FBRyw2QkFBa0IsQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLHVCQUF1QixDQUFDLENBQUM7UUFFdkUsSUFBSSxPQUFPLElBQUksSUFBSSxFQUFFO1lBQ25CLE9BQU8sS0FBSyxDQUFDO1NBQ2Q7S0FDRjtJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQVRELDRCQVNDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5pbXBvcnQgeyBDZm5SZXNvdXJjZSB9IGZyb20gJ21vbm9jZGsnO1xuaW1wb3J0IHsgQ2ZuVHJhaWwgfSBmcm9tICdtb25vY2RrL2F3cy1jbG91ZHRyYWlsJztcbmltcG9ydCB7IHJlc29sdmVJZlByaW1pdGl2ZSB9IGZyb20gJy4uLy4uLy4uL25hZy1wYWNrJztcbi8qKlxuICogQ2xvdWRUcmFpbCB0cmFpbHMgaGF2ZSBsb2cgZmlsZSB2YWxpZGF0aW9uIGVuYWJsZWQgLSAoQ29udHJvbCBJRDogQUMtNilcbiAqIEBwYXJhbSBub2RlIHRoZSBDZm5SZXNvdXJjZSB0byBjaGVja1xuICovXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiAobm9kZTogQ2ZuUmVzb3VyY2UpOiBib29sZWFuIHtcbiAgaWYgKG5vZGUgaW5zdGFuY2VvZiBDZm5UcmFpbCkge1xuICAgIGNvbnN0IGVuYWJsZWQgPSByZXNvbHZlSWZQcmltaXRpdmUobm9kZSwgbm9kZS5lbmFibGVMb2dGaWxlVmFsaWRhdGlvbik7XG5cbiAgICBpZiAoZW5hYmxlZCAhPSB0cnVlKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICB9XG4gIHJldHVybiB0cnVlO1xufVxuIl19