"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_rds_1 = require("monocdk/aws-rds");
const nag_pack_1 = require("../../../nag-pack");
/**
 * RDS DB instances are configured to export all possible log types to CloudWatch - (Control IDs: 164.308(a)(3)(ii)(A), 164.308(a)(5)(ii)(C))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_rds_1.CfnDBInstance) {
        const dbType = JSON.stringify(nag_pack_1.resolveIfPrimitive(node, node.engine));
        const dbLogs = JSON.stringify(monocdk_1.Stack.of(node).resolve(node.enableCloudwatchLogsExports));
        if (dbLogs == undefined) {
            return false;
        }
        if (dbType.includes('mariadb') || dbType.includes('mysql')) {
            if (!(dbLogs.includes('audit') &&
                dbLogs.includes('error') &&
                dbLogs.includes('general') &&
                dbLogs.includes('slowquery'))) {
                return false;
            }
        }
        if (dbType.includes('postgres')) {
            if (!(dbLogs.includes('postgresql') && dbLogs.includes('upgrade'))) {
                return false;
            }
        }
        if (dbType.includes('oracle')) {
            if (!(dbLogs.includes('audit') &&
                dbLogs.includes('alert') &&
                dbLogs.includes('listener') &&
                dbLogs.includes('oemagent') &&
                dbLogs.includes('trace'))) {
                return false;
            }
        }
        if (dbType.includes('sqlserver')) {
            if (!(dbLogs.includes('agent') && dbLogs.includes('error')))
                return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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