"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_elasticbeanstalk_1 = require("monocdk/aws-elasticbeanstalk");
/**
 * Elastic Beanstalk environments have managed updates enabled - (Control ID: 164.308(a)(5)(ii)(A))
 * https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options-general.html#command-options-general-elasticbeanstalkmanagedactions
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_elasticbeanstalk_1.CfnEnvironment) {
        const optionSettings = monocdk_1.Stack.of(node).resolve(node.optionSettings);
        if (optionSettings == undefined) {
            return false;
        }
        let foundEnabled = false;
        let foundLevel = false;
        for (const optionSetting of optionSettings) {
            const resolvedOptionSetting = monocdk_1.Stack.of(node).resolve(optionSetting);
            const namespace = resolvedOptionSetting.namespace;
            const optionName = resolvedOptionSetting.optionName;
            const value = resolvedOptionSetting.value;
            if (namespace === 'aws:elasticbeanstalk:managedactions' &&
                optionName === 'ManagedActionsEnabled' &&
                (value === undefined || value === 'true')) {
                foundEnabled = true;
                if (foundLevel) {
                    break;
                }
            }
            else if (namespace === 'aws:elasticbeanstalk:managedactions:platformupdate' &&
                optionName === 'UpdateLevel' &&
                (value === 'minor' || value === 'patch')) {
                foundLevel = true;
                if (foundEnabled) {
                    break;
                }
            }
        }
        if (!foundEnabled || !foundLevel) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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