"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const monocdk_1 = require("monocdk");
const aws_cloudwatch_1 = require("monocdk/aws-cloudwatch");
/**
 * CloudWatch alarms have at least one alarm action, one INSUFFICIENT_DATA action, or one OK action enabled - (Control ID: 164.312(b))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_cloudwatch_1.CfnAlarm) {
        const actionsEnabled = monocdk_1.Stack.of(node).resolve(node.actionsEnabled);
        if (actionsEnabled === false) {
            return false;
        }
        // Actions can be an array with a token that then resolves to an empty array or undefined
        const alarmActions = monocdk_1.Stack.of(node).resolve(node.alarmActions);
        const insufficientDataActions = monocdk_1.Stack.of(node).resolve(node.insufficientDataActions);
        const okActions = monocdk_1.Stack.of(node).resolve(node.okActions);
        const totalAlarmActions = alarmActions ? alarmActions.length : 0;
        const totalInsufficientDataActions = insufficientDataActions
            ? insufficientDataActions.length
            : 0;
        const totalOkActions = okActions ? okActions.length : 0;
        const totalActions = totalAlarmActions + totalInsufficientDataActions + totalOkActions;
        if (totalActions == 0) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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