"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const aws_autoscaling_1 = require("monocdk/aws-autoscaling");
const nag_pack_1 = require("../../../nag-pack");
/**
 * Auto Scaling launch configurations have public IP addresses disabled - (Control IDs: 164.308(a)(3)(i), 164.308(a)(3)(ii)(B), 164.308(a)(4)(ii)(A), 164.308(a)(4)(ii)(C), 164.312(a)(1), 164.312(e)(1))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_autoscaling_1.CfnLaunchConfiguration) {
        const associatePublicIpAddress = nag_pack_1.resolveIfPrimitive(node, node.associatePublicIpAddress);
        if (associatePublicIpAddress !== false) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaGlwYWFTZWN1cml0eUF1dG9zY2FsaW5nTGF1bmNoQ29uZmlnUHVibGljSXBEaXNhYmxlZC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9ISVBBQS1TZWN1cml0eS9ydWxlcy9hdXRvc2NhbGluZy9oaXBhYVNlY3VyaXR5QXV0b3NjYWxpbmdMYXVuY2hDb25maWdQdWJsaWNJcERpc2FibGVkLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQTs7O0VBR0U7O0FBR0YsNkRBQWlFO0FBQ2pFLGdEQUF1RDtBQUN2RDs7O0dBR0c7QUFDSCxtQkFBeUIsSUFBaUI7SUFDeEMsSUFBSSxJQUFJLFlBQVksd0NBQXNCLEVBQUU7UUFDMUMsTUFBTSx3QkFBd0IsR0FBRyw2QkFBa0IsQ0FDakQsSUFBSSxFQUNKLElBQUksQ0FBQyx3QkFBd0IsQ0FDOUIsQ0FBQztRQUNGLElBQUksd0JBQXdCLEtBQUssS0FBSyxFQUFFO1lBQ3RDLE9BQU8sS0FBSyxDQUFDO1NBQ2Q7S0FDRjtJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQVhELDRCQVdDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5cbmltcG9ydCB7IENmblJlc291cmNlIH0gZnJvbSAnbW9ub2Nkayc7XG5pbXBvcnQgeyBDZm5MYXVuY2hDb25maWd1cmF0aW9uIH0gZnJvbSAnbW9ub2Nkay9hd3MtYXV0b3NjYWxpbmcnO1xuaW1wb3J0IHsgcmVzb2x2ZUlmUHJpbWl0aXZlIH0gZnJvbSAnLi4vLi4vLi4vbmFnLXBhY2snO1xuLyoqXG4gKiBBdXRvIFNjYWxpbmcgbGF1bmNoIGNvbmZpZ3VyYXRpb25zIGhhdmUgcHVibGljIElQIGFkZHJlc3NlcyBkaXNhYmxlZCAtIChDb250cm9sIElEczogMTY0LjMwOChhKSgzKShpKSwgMTY0LjMwOChhKSgzKShpaSkoQiksIDE2NC4zMDgoYSkoNCkoaWkpKEEpLCAxNjQuMzA4KGEpKDQpKGlpKShDKSwgMTY0LjMxMihhKSgxKSwgMTY0LjMxMihlKSgxKSlcbiAqIEBwYXJhbSBub2RlIHRoZSBDZm5SZXNvdXJjZSB0byBjaGVja1xuICovXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiAobm9kZTogQ2ZuUmVzb3VyY2UpOiBib29sZWFuIHtcbiAgaWYgKG5vZGUgaW5zdGFuY2VvZiBDZm5MYXVuY2hDb25maWd1cmF0aW9uKSB7XG4gICAgY29uc3QgYXNzb2NpYXRlUHVibGljSXBBZGRyZXNzID0gcmVzb2x2ZUlmUHJpbWl0aXZlKFxuICAgICAgbm9kZSxcbiAgICAgIG5vZGUuYXNzb2NpYXRlUHVibGljSXBBZGRyZXNzLFxuICAgICk7XG4gICAgaWYgKGFzc29jaWF0ZVB1YmxpY0lwQWRkcmVzcyAhPT0gZmFsc2UpIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG4gIH1cbiAgcmV0dXJuIHRydWU7XG59XG4iXX0=