"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const monocdk_1 = require("monocdk");
const aws_autoscaling_1 = require("monocdk/aws-autoscaling");
const nag_pack_1 = require("../../../nag-pack");
/**
 * Auto Scaling groups which are associated with load balancers utilize ELB health checks - (Control ID: 164.312(b))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_autoscaling_1.CfnAutoScalingGroup) {
        //get all associated CLBs
        const classicLBs = monocdk_1.Stack.of(node).resolve(node.loadBalancerNames);
        //get all associated Application LBs, Gateway LBs, and Network LBs
        const otherLBs = monocdk_1.Stack.of(node).resolve(node.targetGroupArns);
        if ((otherLBs != undefined && otherLBs.length > 0) ||
            (classicLBs != undefined && classicLBs.length > 0)) {
            const healthCheckType = nag_pack_1.resolveIfPrimitive(node, node.healthCheckType);
            //Do we use ELB health checks?
            if (healthCheckType != undefined) {
                if (healthCheckType != 'ELB') {
                    return false;
                }
            }
            else {
                return false;
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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