"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_efs_1 = require("monocdk/aws-efs");
const nag_pack_1 = require("../../../nag-pack");
/**
 * Elastic File Systems are configured for encryption at rest.
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_efs_1.CfnFileSystem) {
        if (node.encrypted == undefined) {
            return false;
        }
        const encrypted = nag_pack_1.resolveIfPrimitive(node, node.encrypted);
        if (encrypted == false) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiRUZTMS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9Bd3NTb2x1dGlvbnMvcnVsZXMvc3RvcmFnZS9FRlMxLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBS0EsNkNBQWdEO0FBQ2hELGdEQUF1RDtBQUV2RDs7O0dBR0c7QUFDSCxtQkFBeUIsSUFBaUI7SUFDeEMsSUFBSSxJQUFJLFlBQVksdUJBQWEsRUFBRTtRQUNqQyxJQUFJLElBQUksQ0FBQyxTQUFTLElBQUksU0FBUyxFQUFFO1lBQy9CLE9BQU8sS0FBSyxDQUFDO1NBQ2Q7UUFDRCxNQUFNLFNBQVMsR0FBRyw2QkFBa0IsQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDO1FBQzNELElBQUksU0FBUyxJQUFJLEtBQUssRUFBRTtZQUN0QixPQUFPLEtBQUssQ0FBQztTQUNkO0tBQ0Y7SUFDRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUFYRCw0QkFXQyIsInNvdXJjZXNDb250ZW50IjpbIi8qXG5Db3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4qL1xuaW1wb3J0IHsgQ2ZuUmVzb3VyY2UgfSBmcm9tICdtb25vY2RrJztcbmltcG9ydCB7IENmbkZpbGVTeXN0ZW0gfSBmcm9tICdtb25vY2RrL2F3cy1lZnMnO1xuaW1wb3J0IHsgcmVzb2x2ZUlmUHJpbWl0aXZlIH0gZnJvbSAnLi4vLi4vLi4vbmFnLXBhY2snO1xuXG4vKipcbiAqIEVsYXN0aWMgRmlsZSBTeXN0ZW1zIGFyZSBjb25maWd1cmVkIGZvciBlbmNyeXB0aW9uIGF0IHJlc3QuXG4gKiBAcGFyYW0gbm9kZSB0aGUgQ2ZuUmVzb3VyY2UgdG8gY2hlY2tcbiAqL1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gKG5vZGU6IENmblJlc291cmNlKTogYm9vbGVhbiB7XG4gIGlmIChub2RlIGluc3RhbmNlb2YgQ2ZuRmlsZVN5c3RlbSkge1xuICAgIGlmIChub2RlLmVuY3J5cHRlZCA9PSB1bmRlZmluZWQpIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG4gICAgY29uc3QgZW5jcnlwdGVkID0gcmVzb2x2ZUlmUHJpbWl0aXZlKG5vZGUsIG5vZGUuZW5jcnlwdGVkKTtcbiAgICBpZiAoZW5jcnlwdGVkID09IGZhbHNlKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICB9XG4gIHJldHVybiB0cnVlO1xufVxuIl19