"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_appsync_1 = require("monocdk/aws-appsync");
const nag_pack_1 = require("../../../nag-pack");
/**
 * GraphQL APIs have request leveling logging enabled
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_appsync_1.CfnGraphQLApi) {
        const logConfig = monocdk_1.Stack.of(node).resolve(node.logConfig);
        if (logConfig === undefined) {
            return false;
        }
        const excludeVerboseContent = nag_pack_1.resolveIfPrimitive(node, logConfig.excludeVerboseContent);
        if (logConfig.cloudWatchLogsRoleArn === undefined ||
            excludeVerboseContent === true) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQVNDMy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9Bd3NTb2x1dGlvbnMvcnVsZXMvc2VydmVybGVzcy9BU0MzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUE7OztFQUdFO0FBQ0YscUNBQTZDO0FBQzdDLHFEQUFvRDtBQUNwRCxnREFBdUQ7QUFFdkQ7OztHQUdHO0FBQ0gsbUJBQXlCLElBQWlCO0lBQ3hDLElBQUksSUFBSSxZQUFZLDJCQUFhLEVBQUU7UUFDakMsTUFBTSxTQUFTLEdBQUcsZUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDO1FBQ3pELElBQUksU0FBUyxLQUFLLFNBQVMsRUFBRTtZQUMzQixPQUFPLEtBQUssQ0FBQztTQUNkO1FBQ0QsTUFBTSxxQkFBcUIsR0FBRyw2QkFBa0IsQ0FDOUMsSUFBSSxFQUNKLFNBQVMsQ0FBQyxxQkFBcUIsQ0FDaEMsQ0FBQztRQUNGLElBQ0UsU0FBUyxDQUFDLHFCQUFxQixLQUFLLFNBQVM7WUFDN0MscUJBQXFCLEtBQUssSUFBSSxFQUM5QjtZQUNBLE9BQU8sS0FBSyxDQUFDO1NBQ2Q7S0FDRjtJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQWxCRCw0QkFrQkMiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cbmltcG9ydCB7IENmblJlc291cmNlLCBTdGFjayB9IGZyb20gJ21vbm9jZGsnO1xuaW1wb3J0IHsgQ2ZuR3JhcGhRTEFwaSB9IGZyb20gJ21vbm9jZGsvYXdzLWFwcHN5bmMnO1xuaW1wb3J0IHsgcmVzb2x2ZUlmUHJpbWl0aXZlIH0gZnJvbSAnLi4vLi4vLi4vbmFnLXBhY2snO1xuXG4vKipcbiAqIEdyYXBoUUwgQVBJcyBoYXZlIHJlcXVlc3QgbGV2ZWxpbmcgbG9nZ2luZyBlbmFibGVkXG4gKiBAcGFyYW0gbm9kZSB0aGUgQ2ZuUmVzb3VyY2UgdG8gY2hlY2tcbiAqL1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gKG5vZGU6IENmblJlc291cmNlKTogYm9vbGVhbiB7XG4gIGlmIChub2RlIGluc3RhbmNlb2YgQ2ZuR3JhcGhRTEFwaSkge1xuICAgIGNvbnN0IGxvZ0NvbmZpZyA9IFN0YWNrLm9mKG5vZGUpLnJlc29sdmUobm9kZS5sb2dDb25maWcpO1xuICAgIGlmIChsb2dDb25maWcgPT09IHVuZGVmaW5lZCkge1xuICAgICAgcmV0dXJuIGZhbHNlO1xuICAgIH1cbiAgICBjb25zdCBleGNsdWRlVmVyYm9zZUNvbnRlbnQgPSByZXNvbHZlSWZQcmltaXRpdmUoXG4gICAgICBub2RlLFxuICAgICAgbG9nQ29uZmlnLmV4Y2x1ZGVWZXJib3NlQ29udGVudCxcbiAgICApO1xuICAgIGlmIChcbiAgICAgIGxvZ0NvbmZpZy5jbG91ZFdhdGNoTG9nc1JvbGVBcm4gPT09IHVuZGVmaW5lZCB8fFxuICAgICAgZXhjbHVkZVZlcmJvc2VDb250ZW50ID09PSB0cnVlXG4gICAgKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICB9XG4gIHJldHVybiB0cnVlO1xufVxuIl19