"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_cognito_1 = require("monocdk/aws-cognito");
const nag_pack_1 = require("../../../nag-pack");
/**
 * Cognito user pools have AdvancedSecurityMode set to ENFORCED
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_cognito_1.CfnUserPool) {
        const userPoolAddOns = monocdk_1.Stack.of(node).resolve(node.userPoolAddOns);
        if (userPoolAddOns == undefined) {
            return false;
        }
        const advancedSecurityMode = nag_pack_1.resolveIfPrimitive(node, userPoolAddOns.advancedSecurityMode);
        if (advancedSecurityMode == undefined ||
            advancedSecurityMode != 'ENFORCED') {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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