"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_apigateway_1 = require("monocdk/aws-apigateway");
const aws_apigatewayv2_1 = require("monocdk/aws-apigatewayv2");
const nag_pack_1 = require("../../../nag-pack");
/**
 * APIs implement authorization
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_apigateway_1.CfnMethod || node instanceof aws_apigatewayv2_1.CfnRoute) {
        const authorizationType = nag_pack_1.resolveIfPrimitive(node, node.authorizationType);
        if (authorizationType == undefined ||
            authorizationType == aws_apigateway_1.AuthorizationType.NONE) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQVBJRzQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvQXdzU29sdXRpb25zL3J1bGVzL25ldHdvcmtfYW5kX2RlbGl2ZXJ5L0FQSUc0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBS0EsMkRBQXNFO0FBQ3RFLCtEQUFvRDtBQUNwRCxnREFBdUQ7QUFFdkQ7OztHQUdHO0FBQ0gsbUJBQXlCLElBQWlCO0lBQ3hDLElBQUksSUFBSSxZQUFZLDBCQUFTLElBQUksSUFBSSxZQUFZLDJCQUFRLEVBQUU7UUFDekQsTUFBTSxpQkFBaUIsR0FBRyw2QkFBa0IsQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLGlCQUFpQixDQUFDLENBQUM7UUFDM0UsSUFDRSxpQkFBaUIsSUFBSSxTQUFTO1lBQzlCLGlCQUFpQixJQUFJLGtDQUFpQixDQUFDLElBQUksRUFDM0M7WUFDQSxPQUFPLEtBQUssQ0FBQztTQUNkO0tBQ0Y7SUFDRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUFYRCw0QkFXQyIsInNvdXJjZXNDb250ZW50IjpbIi8qXG5Db3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4qL1xuaW1wb3J0IHsgQ2ZuUmVzb3VyY2UgfSBmcm9tICdtb25vY2RrJztcbmltcG9ydCB7IEF1dGhvcml6YXRpb25UeXBlLCBDZm5NZXRob2QgfSBmcm9tICdtb25vY2RrL2F3cy1hcGlnYXRld2F5JztcbmltcG9ydCB7IENmblJvdXRlIH0gZnJvbSAnbW9ub2Nkay9hd3MtYXBpZ2F0ZXdheXYyJztcbmltcG9ydCB7IHJlc29sdmVJZlByaW1pdGl2ZSB9IGZyb20gJy4uLy4uLy4uL25hZy1wYWNrJztcblxuLyoqXG4gKiBBUElzIGltcGxlbWVudCBhdXRob3JpemF0aW9uXG4gKiBAcGFyYW0gbm9kZSB0aGUgQ2ZuUmVzb3VyY2UgdG8gY2hlY2tcbiAqL1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gKG5vZGU6IENmblJlc291cmNlKTogYm9vbGVhbiB7XG4gIGlmIChub2RlIGluc3RhbmNlb2YgQ2ZuTWV0aG9kIHx8IG5vZGUgaW5zdGFuY2VvZiBDZm5Sb3V0ZSkge1xuICAgIGNvbnN0IGF1dGhvcml6YXRpb25UeXBlID0gcmVzb2x2ZUlmUHJpbWl0aXZlKG5vZGUsIG5vZGUuYXV0aG9yaXphdGlvblR5cGUpO1xuICAgIGlmIChcbiAgICAgIGF1dGhvcml6YXRpb25UeXBlID09IHVuZGVmaW5lZCB8fFxuICAgICAgYXV0aG9yaXphdGlvblR5cGUgPT0gQXV0aG9yaXphdGlvblR5cGUuTk9ORVxuICAgICkge1xuICAgICAgcmV0dXJuIGZhbHNlO1xuICAgIH1cbiAgfVxuICByZXR1cm4gdHJ1ZTtcbn1cbiJdfQ==