"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_autoscaling_1 = require("monocdk/aws-autoscaling");
const nag_pack_1 = require("../../../nag-pack");
/**
 * Auto Scaling Groups have properly configured health checks
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_autoscaling_1.CfnAutoScalingGroup) {
        const healthCheckType = nag_pack_1.resolveIfPrimitive(node, node.healthCheckType);
        const healthCheckGracePeriod = nag_pack_1.resolveIfPrimitive(node, node.healthCheckGracePeriod);
        if (healthCheckType != undefined &&
            healthCheckType == 'ELB' &&
            healthCheckGracePeriod == undefined) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQVMyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL0F3c1NvbHV0aW9ucy9ydWxlcy9tYW5hZ2VtZW50X2FuZF9nb3Zlcm5hbmNlL0FTMi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUtBLDZEQUE4RDtBQUM5RCxnREFBdUQ7QUFFdkQ7OztHQUdHO0FBQ0gsbUJBQXlCLElBQWlCO0lBQ3hDLElBQUksSUFBSSxZQUFZLHFDQUFtQixFQUFFO1FBQ3ZDLE1BQU0sZUFBZSxHQUFHLDZCQUFrQixDQUFDLElBQUksRUFBRSxJQUFJLENBQUMsZUFBZSxDQUFDLENBQUM7UUFDdkUsTUFBTSxzQkFBc0IsR0FBRyw2QkFBa0IsQ0FDL0MsSUFBSSxFQUNKLElBQUksQ0FBQyxzQkFBc0IsQ0FDNUIsQ0FBQztRQUNGLElBQ0UsZUFBZSxJQUFJLFNBQVM7WUFDNUIsZUFBZSxJQUFJLEtBQUs7WUFDeEIsc0JBQXNCLElBQUksU0FBUyxFQUNuQztZQUNBLE9BQU8sS0FBSyxDQUFDO1NBQ2Q7S0FDRjtJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQWhCRCw0QkFnQkMiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cbmltcG9ydCB7IENmblJlc291cmNlIH0gZnJvbSAnbW9ub2Nkayc7XG5pbXBvcnQgeyBDZm5BdXRvU2NhbGluZ0dyb3VwIH0gZnJvbSAnbW9ub2Nkay9hd3MtYXV0b3NjYWxpbmcnO1xuaW1wb3J0IHsgcmVzb2x2ZUlmUHJpbWl0aXZlIH0gZnJvbSAnLi4vLi4vLi4vbmFnLXBhY2snO1xuXG4vKipcbiAqIEF1dG8gU2NhbGluZyBHcm91cHMgaGF2ZSBwcm9wZXJseSBjb25maWd1cmVkIGhlYWx0aCBjaGVja3NcbiAqIEBwYXJhbSBub2RlIHRoZSBDZm5SZXNvdXJjZSB0byBjaGVja1xuICovXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiAobm9kZTogQ2ZuUmVzb3VyY2UpOiBib29sZWFuIHtcbiAgaWYgKG5vZGUgaW5zdGFuY2VvZiBDZm5BdXRvU2NhbGluZ0dyb3VwKSB7XG4gICAgY29uc3QgaGVhbHRoQ2hlY2tUeXBlID0gcmVzb2x2ZUlmUHJpbWl0aXZlKG5vZGUsIG5vZGUuaGVhbHRoQ2hlY2tUeXBlKTtcbiAgICBjb25zdCBoZWFsdGhDaGVja0dyYWNlUGVyaW9kID0gcmVzb2x2ZUlmUHJpbWl0aXZlKFxuICAgICAgbm9kZSxcbiAgICAgIG5vZGUuaGVhbHRoQ2hlY2tHcmFjZVBlcmlvZCxcbiAgICApO1xuICAgIGlmIChcbiAgICAgIGhlYWx0aENoZWNrVHlwZSAhPSB1bmRlZmluZWQgJiZcbiAgICAgIGhlYWx0aENoZWNrVHlwZSA9PSAnRUxCJyAmJlxuICAgICAgaGVhbHRoQ2hlY2tHcmFjZVBlcmlvZCA9PSB1bmRlZmluZWRcbiAgICApIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG4gIH1cbiAgcmV0dXJuIHRydWU7XG59XG4iXX0=