"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_neptune_1 = require("monocdk/aws-neptune");
const nag_pack_1 = require("../../../nag-pack");
/**
 * Neptune DB instances have Auto Minor Version Upgrade enabled
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_neptune_1.CfnDBInstance) {
        if (node.autoMinorVersionUpgrade == undefined) {
            return false;
        }
        const autoMinorVersionUpgrade = nag_pack_1.resolveIfPrimitive(node, node.autoMinorVersionUpgrade);
        if (!autoMinorVersionUpgrade) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiTjIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvQXdzU29sdXRpb25zL3J1bGVzL2RhdGFiYXNlcy9OMi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUtBLHFEQUFvRDtBQUNwRCxnREFBdUQ7QUFFdkQ7OztHQUdHO0FBQ0gsbUJBQXlCLElBQWlCO0lBQ3hDLElBQUksSUFBSSxZQUFZLDJCQUFhLEVBQUU7UUFDakMsSUFBSSxJQUFJLENBQUMsdUJBQXVCLElBQUksU0FBUyxFQUFFO1lBQzdDLE9BQU8sS0FBSyxDQUFDO1NBQ2Q7UUFDRCxNQUFNLHVCQUF1QixHQUFHLDZCQUFrQixDQUNoRCxJQUFJLEVBQ0osSUFBSSxDQUFDLHVCQUF1QixDQUM3QixDQUFDO1FBQ0YsSUFBSSxDQUFDLHVCQUF1QixFQUFFO1lBQzVCLE9BQU8sS0FBSyxDQUFDO1NBQ2Q7S0FDRjtJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQWRELDRCQWNDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5pbXBvcnQgeyBDZm5SZXNvdXJjZSB9IGZyb20gJ21vbm9jZGsnO1xuaW1wb3J0IHsgQ2ZuREJJbnN0YW5jZSB9IGZyb20gJ21vbm9jZGsvYXdzLW5lcHR1bmUnO1xuaW1wb3J0IHsgcmVzb2x2ZUlmUHJpbWl0aXZlIH0gZnJvbSAnLi4vLi4vLi4vbmFnLXBhY2snO1xuXG4vKipcbiAqIE5lcHR1bmUgREIgaW5zdGFuY2VzIGhhdmUgQXV0byBNaW5vciBWZXJzaW9uIFVwZ3JhZGUgZW5hYmxlZFxuICogQHBhcmFtIG5vZGUgdGhlIENmblJlc291cmNlIHRvIGNoZWNrXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIChub2RlOiBDZm5SZXNvdXJjZSk6IGJvb2xlYW4ge1xuICBpZiAobm9kZSBpbnN0YW5jZW9mIENmbkRCSW5zdGFuY2UpIHtcbiAgICBpZiAobm9kZS5hdXRvTWlub3JWZXJzaW9uVXBncmFkZSA9PSB1bmRlZmluZWQpIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG4gICAgY29uc3QgYXV0b01pbm9yVmVyc2lvblVwZ3JhZGUgPSByZXNvbHZlSWZQcmltaXRpdmUoXG4gICAgICBub2RlLFxuICAgICAgbm9kZS5hdXRvTWlub3JWZXJzaW9uVXBncmFkZSxcbiAgICApO1xuICAgIGlmICghYXV0b01pbm9yVmVyc2lvblVwZ3JhZGUpIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG4gIH1cbiAgcmV0dXJuIHRydWU7XG59XG4iXX0=