"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_ecs_1 = require("monocdk/aws-ecs");
const nag_pack_1 = require("../../../nag-pack");
/**
 * ECS Task Definition has awslogs logging enabled at the minimum
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_ecs_1.CfnCluster) {
        if (node.configuration == undefined) {
            return false;
        }
        const configuration = monocdk_1.Stack.of(node).resolve(node.configuration);
        if (configuration.executeCommandConfiguration == undefined) {
            return false;
        }
        const executeCommandConfiguration = nag_pack_1.resolveIfPrimitive(node, configuration.executeCommandConfiguration);
        if (executeCommandConfiguration.logging == undefined ||
            executeCommandConfiguration.logging == 'NONE') {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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