"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_ecs_1 = require("monocdk/aws-ecs");
/**
 * ECS Cluster has CloudWatch Container Insights Enabled
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_ecs_1.CfnCluster) {
        if (node.clusterSettings == undefined) {
            return false;
        }
        const clusterSettings = monocdk_1.Stack.of(node).resolve(node.clusterSettings);
        for (const setting of clusterSettings) {
            const resolvedSetting = monocdk_1.Stack.of(node).resolve(setting);
            if (resolvedSetting.name &&
                resolvedSetting.name == 'containerInsights' &&
                resolvedSetting.value &&
                resolvedSetting.value == 'enabled') {
                return true;
            }
        }
        return false;
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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