"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_elasticbeanstalk_1 = require("monocdk/aws-elasticbeanstalk");
/**
 * Elastic Beanstalk environments have managed updates enabled
 * https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options-general.html#command-options-general-elasticbeanstalkmanagedactions
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_elasticbeanstalk_1.CfnEnvironment) {
        const optionSettings = monocdk_1.Stack.of(node).resolve(node.optionSettings);
        if (optionSettings == undefined) {
            return false;
        }
        let foundEnabled = false;
        let foundLevel = false;
        for (const optionSetting of optionSettings) {
            const resolvedOptionSetting = monocdk_1.Stack.of(node).resolve(optionSetting);
            const namespace = resolvedOptionSetting.namespace;
            const optionName = resolvedOptionSetting.optionName;
            const value = resolvedOptionSetting.value;
            if (namespace === 'aws:elasticbeanstalk:managedactions' &&
                optionName === 'ManagedActionsEnabled' &&
                (value === undefined || value === 'true')) {
                foundEnabled = true;
                if (foundLevel) {
                    break;
                }
            }
            else if (namespace === 'aws:elasticbeanstalk:managedactions:platformupdate' &&
                optionName === 'UpdateLevel' &&
                (value === 'minor' || value === 'patch')) {
                foundLevel = true;
                if (foundEnabled) {
                    break;
                }
            }
        }
        if (!foundEnabled || !foundLevel) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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